/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.twofactor.core;

import com.alphaserve.twofactor.core.dtolayer.dtos.wrapper.UrlRecord;
import com.alphaserve.twofactor.core.factory.UrlRecordFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class Plugin2FACoreContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Plugin2FACoreContext.class);
    public static final int DEFAULT_NUMBER_ATTEMPTS = 3;
    public static final int DEFAULT_LOCKOUT_PERIOD = 15;
    public static final String DEFAULT_PERMISSION_TYPE = "permissionNone";
    private final int defaultKeySize;
    private final int defaultTimeStep;
    private final int defaultRememberMeExpireHours;
    private final String pluginKey;
    private final String backupFileName;
    private final String userDecorator;
    private final String defaultForceType;
    private final String defaultAuthLabel;
    private final String defaultResidentKey;
    private final String defaultResourcePath;
    private final String deleteUsernameField;
    private final String defaultForceGroupsList;
    private final String defaultAttestationType;
    private final String defaultUserVerification;
    private final ApplicationProperties applicationProperties;
    private final UrlRecord[] endSecurityUrls;
    private final UrlRecord[] securityPrefixes;
    private final UrlRecord defaultBlacklistNotLogged2fa;
    private final UrlRecord[] defaultUrlBlacklistUnlogged;
    private final UrlRecord[] defaultUrlBlacklistUnlogged2fa;
    private final UrlRecord[] whitelistOnForce;
    private final UrlRecord[] whitelistOnOAuthEnabled;
    private final UrlRecord[] whitelistOnUserEnabled2fa;
    private final UrlRecord[] defaultUrlWhitelistContains;
    private final UrlRecord[] defaultUrlWhitelistPrefixes;

    private UrlRecord[] getAndHandleAuthConfigProperty(String key, String baseUrl, Properties pluginProperties) {
        String property = pluginProperties.getProperty(key);
        if (property != null) {
            if (property.contains(",")) {
                return (UrlRecord[])Arrays.stream(property.split(",")).map(url -> UrlRecordFactory.autoResolveAndCreateUrlRecord(baseUrl, url)).toArray(UrlRecord[]::new);
            }
            return new UrlRecord[]{UrlRecordFactory.autoResolveAndCreateUrlRecord(baseUrl, property)};
        }
        return new UrlRecord[0];
    }

    @Inject
    public Plugin2FACoreContext(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        try {
            String baseUrl = applicationProperties.getBaseUrl(UrlMode.RELATIVE);
            Properties properties = new Properties();
            properties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("auth-config.properties"));
            this.defaultKeySize = Integer.parseInt(properties.getProperty("default_key_size"));
            this.defaultRememberMeExpireHours = Integer.parseInt(properties.getProperty("default_remember_me_expire_hours"));
            this.pluginKey = properties.getProperty("plugin_key");
            this.backupFileName = properties.getProperty("backup_codes");
            this.userDecorator = properties.getProperty("user_decorator");
            this.defaultTimeStep = Integer.parseInt(properties.getProperty("default_time_step"));
            this.defaultForceType = properties.getProperty("default_force_type");
            this.defaultAuthLabel = properties.getProperty("default_auth_label");
            this.defaultResidentKey = properties.getProperty("default_resident_key");
            this.defaultResourcePath = properties.getProperty("default_resource_path");
            this.deleteUsernameField = properties.getProperty("delete_username_field");
            this.defaultForceGroupsList = properties.getProperty("default_force_groups_list");
            this.defaultAttestationType = properties.getProperty("default_attestation_type");
            this.defaultUserVerification = properties.getProperty("default_user_verification");
            this.endSecurityUrls = this.getAndHandleAuthConfigProperty("end_security_urls", null, properties);
            this.securityPrefixes = this.getAndHandleAuthConfigProperty("security_prefixes", baseUrl, properties);
            this.defaultBlacklistNotLogged2fa = UrlRecordFactory.createUrlRecord(baseUrl, "/rest/authpluginresources/1.0/");
            this.defaultUrlBlacklistUnlogged = this.getAndHandleAuthConfigProperty("default_url_blacklist_unlogged", baseUrl, properties);
            this.defaultUrlBlacklistUnlogged2fa = this.getAndHandleAuthConfigProperty("default_url_blacklist_unlogged_2fa", baseUrl, properties);
            this.whitelistOnForce = UrlRecordFactory.autoResolveAndCreateUrlRecords(baseUrl, "/rest/authpluginresources/1.0/totp_resources/get_qr_image", "rest/authpluginresources/1.0/totp_resources/enable_totp");
            this.whitelistOnOAuthEnabled = UrlRecordFactory.autoResolveAndCreateUrlRecords(baseUrl, "/rest/token-auth/api/", "/download/token-auth/attachments/", "/plugins/servlet/imgFilter", "/rest/analytics/1.0/publish/bulk", "/download/attachments", "/plugins/servlet/applinks/whoami");
            this.whitelistOnUserEnabled2fa = UrlRecordFactory.autoResolveAndCreateUrlRecords(baseUrl, "/rest/authpluginresources/1.0/totp_resources/login", "/rest/authpluginresources/1.0/totp_resources/reserve_key_login", "/rest/authpluginresources/1.0/u2f_resources/login", "/rest/authpluginresources/1.0/tfaservices/logout", "/rest/authpluginresources/1.0/u2f_resources/init_login", "/rest/authpluginresources/1.0/webauth_resources/init_assertion", "/rest/authpluginresources/1.0/logger/add_failed", "/rest/authpluginresources/1.0/webauth_resources/finish_login");
            this.defaultUrlWhitelistContains = this.getAndHandleAuthConfigProperty("default_url_whitelist_contains", baseUrl, properties);
            this.defaultUrlWhitelistPrefixes = this.getAndHandleAuthConfigProperty("default_url_whitelist_prefixes", baseUrl, properties);
        }
        catch (IOException ioException) {
            MissingResourceException exception = new MissingResourceException("Unable to read plugin info from auth-config.properties", Plugin2FACoreContext.class.getName(), null);
            exception.addSuppressed(ioException);
            throw exception;
        }
    }

    public String getBaseUrl(UrlMode urlMode) {
        return this.applicationProperties.getBaseUrl(urlMode);
    }

    public Optional<UrlRecord[]> getDefaultUrlBlacklistUnlogged2faOptional() {
        return Optional.of(this.defaultUrlBlacklistUnlogged2fa);
    }

    @Generated
    public int getDefaultKeySize() {
        return this.defaultKeySize;
    }

    @Generated
    public int getDefaultTimeStep() {
        return this.defaultTimeStep;
    }

    @Generated
    public int getDefaultRememberMeExpireHours() {
        return this.defaultRememberMeExpireHours;
    }

    @Generated
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Generated
    public String getBackupFileName() {
        return this.backupFileName;
    }

    @Generated
    public String getUserDecorator() {
        return this.userDecorator;
    }

    @Generated
    public String getDefaultForceType() {
        return this.defaultForceType;
    }

    @Generated
    public String getDefaultAuthLabel() {
        return this.defaultAuthLabel;
    }

    @Generated
    public String getDefaultResidentKey() {
        return this.defaultResidentKey;
    }

    @Generated
    public String getDefaultResourcePath() {
        return this.defaultResourcePath;
    }

    @Generated
    public String getDeleteUsernameField() {
        return this.deleteUsernameField;
    }

    @Generated
    public String getDefaultForceGroupsList() {
        return this.defaultForceGroupsList;
    }

    @Generated
    public String getDefaultAttestationType() {
        return this.defaultAttestationType;
    }

    @Generated
    public String getDefaultUserVerification() {
        return this.defaultUserVerification;
    }

    @Generated
    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    @Generated
    public UrlRecord[] getEndSecurityUrls() {
        return this.endSecurityUrls;
    }

    @Generated
    public UrlRecord[] getSecurityPrefixes() {
        return this.securityPrefixes;
    }

    @Generated
    public UrlRecord getDefaultBlacklistNotLogged2fa() {
        return this.defaultBlacklistNotLogged2fa;
    }

    @Generated
    public UrlRecord[] getDefaultUrlBlacklistUnlogged() {
        return this.defaultUrlBlacklistUnlogged;
    }

    @Generated
    public UrlRecord[] getDefaultUrlBlacklistUnlogged2fa() {
        return this.defaultUrlBlacklistUnlogged2fa;
    }

    @Generated
    public UrlRecord[] getWhitelistOnForce() {
        return this.whitelistOnForce;
    }

    @Generated
    public UrlRecord[] getWhitelistOnOAuthEnabled() {
        return this.whitelistOnOAuthEnabled;
    }

    @Generated
    public UrlRecord[] getWhitelistOnUserEnabled2fa() {
        return this.whitelistOnUserEnabled2fa;
    }

    @Generated
    public UrlRecord[] getDefaultUrlWhitelistContains() {
        return this.defaultUrlWhitelistContains;
    }

    @Generated
    public UrlRecord[] getDefaultUrlWhitelistPrefixes() {
        return this.defaultUrlWhitelistPrefixes;
    }
}

