/*
 * Decompiled with CFR 0.152.
 */
package com.alphaserve.confluence.authplugin.services;

import com.alphaserve.twofactor.core.model.entities.U2FDevice;
import com.alphaserve.twofactor.core.services.entities.impl.U2FDeviceServiceImpl;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;

@Named
public class ConfluenceU2FDeviceServiceImpl
extends U2FDeviceServiceImpl {
    @Inject
    public ConfluenceU2FDeviceServiceImpl(@ComponentImport ActiveObjects ao, UserManager salUserManager) {
        super(ao, salUserManager);
    }

    @Override
    public List<U2FDevice> getByUserKey(UserKey userKey) {
        UserProfile remoteUser = this.salUserManager.getUserProfile(userKey);
        if (Objects.isNull(remoteUser)) {
            return new ArrayList<U2FDevice>();
        }
        Query query = Query.select().where("USERKEY = ? OR USERNAME = ?", new Object[]{userKey.getStringValue(), userKey.getStringValue()});
        U2FDevice[] userAuthSetting = (U2FDevice[])this.ao.executeInTransaction(() -> (U2FDevice[])this.ao.find(U2FDevice.class, query));
        if (Objects.isNull(userAuthSetting)) {
            return new ArrayList<U2FDevice>();
        }
        return Lists.newArrayList(userAuthSetting);
    }

    @Override
    public boolean hasRemoteUserU2FDevice() {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return false;
        }
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(U2FDevice.class, Query.select().where("USERKEY = ? OR USERNAME = ?", new Object[]{remoteUser.getUserKey().getStringValue(), remoteUser.getUserKey().getStringValue()}))) > 0;
    }

    @Override
    public long getDeviceCountByName(String name) {
        UserProfile remoteUser = this.salUserManager.getRemoteUser();
        if (Objects.isNull(remoteUser)) {
            return 0L;
        }
        return ((Integer)this.ao.executeInTransaction(() -> this.ao.count(U2FDevice.class, Query.select().where("NAME = ? AND (USERKEY = ? OR USERNAME = ?)", new Object[]{name, remoteUser.getUserKey().getStringValue(), remoteUser.getUserKey().getStringValue()})))).intValue();
    }
}

