/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.parameter;

import java.util.function.Function;
import java.util.function.Predicate;

public class MacroParameter {
    private final String myName;
    private final boolean myRequired;
    private final String myDefaultValue;
    private final Predicate<String> myValidation;
    private final Function<String, String> myCorrection;

    public MacroParameter(String name) {
        this(name, false, x -> true);
    }

    public MacroParameter(String name, boolean required, Predicate<String> validation) {
        this(name, required, null, validation, Function.identity());
    }

    public MacroParameter(String name, boolean required, String defaultValue, Predicate<String> validation, Function<String, String> correction) {
        this.myName = name;
        this.myRequired = required;
        this.myDefaultValue = defaultValue;
        this.myValidation = validation;
        this.myCorrection = correction;
    }

    public boolean isValid(String value) {
        if (value == null) {
            return !this.myRequired;
        }
        return this.myValidation.test(value);
    }

    public String correct(String value) {
        return this.myCorrection.apply(value);
    }

    public String getName() {
        return this.myName;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }
}

