/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroAppLinkClient {
    private final ReadOnlyApplicationLinkService myLinkService;

    public MacroAppLinkClient(ReadOnlyApplicationLinkService linkService) {
        this.myLinkService = linkService;
    }

    public Response get(ApplicationLinkRequestFactory factory, String url) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = factory.createRequest(Request.MethodType.GET, url);
        request.setHeader("Content-Type", "application/json");
        return (Response)request.execute((ApplicationLinkResponseHandler)AppLinkResponseHandler.INSTANCE);
    }

    @NotNull
    public List<ReadOnlyApplicationLink> getJiraLinks() {
        ArrayList<ReadOnlyApplicationLink> links = new ArrayList<ReadOnlyApplicationLink>();
        for (ReadOnlyApplicationLink link : this.myLinkService.getApplicationLinks()) {
            if (!(link.getType() instanceof JiraApplicationType)) continue;
            links.add(link);
        }
        return links;
    }

    @Nullable
    public ReadOnlyApplicationLink getJiraLink(String appLinkId) {
        if (StringUtils.isBlank((CharSequence)appLinkId)) {
            return null;
        }
        for (ReadOnlyApplicationLink link : this.myLinkService.getApplicationLinks()) {
            if (!(link.getType() instanceof JiraApplicationType) || !Objects.equals(link.getId().get(), appLinkId)) continue;
            return link;
        }
        return null;
    }

    public static class AppLinkResponseHandler
    implements ApplicationLinkResponseHandler<Response> {
        public static AppLinkResponseHandler INSTANCE = new AppLinkResponseHandler();

        public Response credentialsRequired(Response response) {
            return response;
        }

        public Response handle(Response response) {
            return response;
        }
    }
}

