/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.servlet.jakarta;

import com.almworks.structure.commons.security.SecurityInterceptorEnhancer;
import com.almworks.structure.compat.bridge.HttpRequestBridge;
import com.almworks.structure.compat.bridge.HttpResponseBridge;
import com.almworks.structure.compat.bridge.ServletBridges;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecurityFilter.class);
    private static final String CONFLUENCE_HELPER_PLUGIN_KEY = "com.almworks.structure.confluence.helper";
    private final SecurityInterceptorEnhancer myEnhancer;
    private final ServletBridges myServletBridges;

    @VisibleForTesting
    SecurityFilter(SecurityInterceptorEnhancer enhancer, ServletBridges bridges) {
        this.myEnhancer = enhancer;
        this.myServletBridges = bridges;
    }

    public SecurityFilter(ReadOnlyApplicationLinkService linkService, CacheManager cacheManager, EventPublisher eventPublisher, ServletBridges servletBridges) {
        this.myEnhancer = new SecurityInterceptorEnhancer(CONFLUENCE_HELPER_PLUGIN_KEY, linkService, cacheManager, eventPublisher);
        this.myServletBridges = servletBridges;
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, FilterChain chain) {
        try {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)response){

                    public void setHeader(String name, String value) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Security-Policy") || SecurityFilter.this.shouldEnforceCSPHeader((HttpServletRequest)request)) {
                            HttpResponseBridge responseBridge = SecurityFilter.this.myServletBridges.forResponse((Object)response);
                            SecurityFilter.this.myEnhancer.setContentSecurityPolicy(responseBridge, value);
                        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"X-Frame-Options")) {
                            HttpRequestBridge requestBridge = SecurityFilter.this.myServletBridges.forRequest((Object)request);
                            HttpResponseBridge responseBridge = SecurityFilter.this.myServletBridges.forResponse((Object)response);
                            SecurityFilter.this.myEnhancer.setXFrameOptions(requestBridge, responseBridge, value);
                        } else {
                            super.setHeader(name, value);
                        }
                    }
                });
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception in servlet filter", (Throwable)e);
        }
    }

    private boolean shouldEnforceCSPHeader(HttpServletRequest request) {
        Optional<String> url = Optional.ofNullable(request.getRequestURL()).map(StringBuffer::toString);
        return url.isPresent() && (this.isMacroBrowserIframe(url.get()) || this.isGadgetPluginRequest(url.get()));
    }

    private boolean isGadgetPluginRequest(String url) {
        return url.contains("/plugins/servlet/gadgets");
    }

    private boolean isMacroBrowserIframe(String url) {
        return url.contains("blank.html");
    }

    public void destroy() {
        logger.warn("{} stopping", (Object)this);
        this.myEnhancer.destroy();
    }

    public void init(FilterConfig filterConfig) {
    }
}

