/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.servlet.jakarta;

import com.almworks.structure.commons.security.CookieAttributeAppender;
import com.almworks.structure.commons.security.SecurityInterceptorEnhancer;
import com.almworks.structure.compat.bridge.HttpRequestBridge;
import com.almworks.structure.compat.bridge.HttpResponseBridge;
import com.almworks.structure.compat.bridge.ServletBridges;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSiteCookieAttributeFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SameSiteCookieAttributeFilter.class);
    private final ServletBridges myServletBridges;

    public SameSiteCookieAttributeFilter(ServletBridges servletBridges) {
        this.myServletBridges = servletBridges;
    }

    public void init(@NotNull FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ("https".equalsIgnoreCase(request.getScheme()) && response instanceof HttpServletResponse && request instanceof HttpServletRequest && SecurityInterceptorEnhancer.hasOurCookie((HttpRequestBridge)this.myServletBridges.forRequest((Object)request))) {
            chain.doFilter(request, (ServletResponse)new SameSiteCookieWrapper((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    private class SameSiteCookieWrapper
    extends HttpServletResponseWrapper {
        @NotNull
        private final HttpResponseBridge myResponseBridge;

        public SameSiteCookieWrapper(HttpServletResponse response) {
            super(response);
            this.myResponseBridge = SameSiteCookieAttributeFilter.this.myServletBridges.forResponse((Object)response);
        }

        public void sendRedirect(String location) throws IOException {
            SameSiteCookieAttributeFilter.this.logger.debug("sendRedirect(String) called");
            CookieAttributeAppender.appendCookieAttributes((HttpResponseBridge)this.myResponseBridge, (CookieAttributeAppender.CookieAttribute[])new CookieAttributeAppender.CookieAttribute[]{CookieAttributeAppender.CookieAttribute.SAME_SITE_NONE, CookieAttributeAppender.CookieAttribute.SECURE});
            super.sendRedirect(location);
        }
    }
}

