/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.rest.javax;

import com.almworks.structure.confluence.helper.AppLinkClient;
import com.almworks.structure.confluence.helper.Subscription;
import com.almworks.structure.confluence.helper.SubscriptionManager;
import com.almworks.structure.confluence.helper.cluster.PagesSubscriptionEvent;
import com.almworks.structure.confluence.helper.rest.data.RestNotificationSubscription;
import com.almworks.structure.confluence.helper.rest.data.RestNotificationSubscriptionError;
import com.almworks.structure.confluence.helper.rest.data.RestNotificationSubscriptionRequest;
import com.almworks.structure.confluence.helper.rest.data.RestTestRequest;
import com.almworks.structure.confluence.helper.rest.data.RestTestResponse;
import com.almworks.structure.confluence.helper.rest.javax.AbstractResource;
import com.almworks.structure.confluence.helper.util.RemoteResponse;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notification")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@UnrestrictedAccess
public class NotificationResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(NotificationResource.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final SubscriptionManager mySubscriptionManager;
    private final AppLinkClient myAppLinkClient;
    private final EventPublisher myEventPublisher;
    private final ClusterManager myClusterManager;

    @Inject
    public NotificationResource(SubscriptionManager subscriptionManager, AppLinkClient appLinkClient, EventPublisher eventPublisher, ClusterManager clusterManager) {
        this.mySubscriptionManager = subscriptionManager;
        this.myAppLinkClient = appLinkClient;
        this.myEventPublisher = eventPublisher;
        this.myClusterManager = clusterManager;
    }

    @POST
    @Path(value="/subscription")
    @ReadOnlyAccessAllowed
    public Response subscribe(RestNotificationSubscriptionRequest request) {
        NotificationResource.logReceive("POST on /subscription", request);
        try {
            URI baseUrl = new URI(request.baseUrl);
            Subscription subscription = this.mySubscriptionManager.subscribe(baseUrl, "/rest/structure-pages/1.0/notification", request.appLinkId, request.timeToLiveMillis);
            RestNotificationSubscription r = new RestNotificationSubscription();
            r.expiration = subscription.getExpirationMillis();
            r.receiverAppLinkId = subscription.getReceiverAppLinkId();
            if (this.myClusterManager.isClustered()) {
                this.myEventPublisher.publish((Object)new PagesSubscriptionEvent(this.myClusterManager.getThisNodeInformation(), request.baseUrl, request.appLinkId, request.timeToLiveMillis));
            }
            return NotificationResource.ok(r);
        }
        catch (AppLinkClient.NoAppLinkException e) {
            RestNotificationSubscriptionError r = new RestNotificationSubscriptionError();
            r.error = "Cannot find an application link for the specified base URL";
            r.baseUrl = request.baseUrl;
            return NotificationResource.error(Response.Status.INTERNAL_SERVER_ERROR, r);
        }
        catch (URISyntaxException e) {
            RestNotificationSubscriptionError r = new RestNotificationSubscriptionError();
            r.error = "Malformed base URL";
            r.baseUrl = request.baseUrl;
            return NotificationResource.error(Response.Status.BAD_REQUEST, r);
        }
    }

    @POST
    @Path(value="/ping")
    @ReadOnlyAccessAllowed
    public Response ping(RestTestRequest pingRequest) {
        NotificationResource.logReceive("POST on /ping", pingRequest);
        RestTestResponse pingResponse = new RestTestResponse();
        pingResponse.appLinkId = pingRequest.appLinkId;
        try {
            ReadOnlyApplicationLink link = this.myAppLinkClient.findLink(new URI(pingRequest.baseUrl));
            RemoteResponse<RestTestRequest> pongRemoteResponse = AppLinkClient.anonymousPost(link, "/rest/structure-pages/1.0/notification/pong", pingRequest, RestTestRequest.class);
            if (!pongRemoteResponse.isSuccessful()) {
                log.warn("Pong response for {} failed: {}", (Object)pingRequest.appLinkId, pongRemoteResponse);
                return NotificationResource.pingError(Response.Status.INTERNAL_SERVER_ERROR, "pongResponseFailed", pongRemoteResponse.getStatusString(), pingResponse);
            }
            RestTestRequest pongResponse = pongRemoteResponse.getEntity();
            if (pongResponse == null) {
                log.warn("Cannot read pong response for {}: {}", (Object)pingRequest.appLinkId, pongRemoteResponse);
                return NotificationResource.pingError(Response.Status.INTERNAL_SERVER_ERROR, "pongResponseBadFormat", pingResponse);
            }
            NotificationResource.logReceive("response to /pong", pongResponse);
            pingResponse.payload = pongResponse.payload;
            return NotificationResource.ok(pingResponse);
        }
        catch (AppLinkClient.NoAppLinkException e) {
            return NotificationResource.pingError(Response.Status.INTERNAL_SERVER_ERROR, "appLinkNotFound", pingResponse);
        }
        catch (CredentialsRequiredException e) {
            return NotificationResource.pingError(Response.Status.INTERNAL_SERVER_ERROR, "credentialsRequired", pingResponse);
        }
        catch (ResponseException e) {
            NotificationResource.warnExceptionIfDebug("test for " + pingRequest.appLinkId + " failed with ResponseException", e);
            return NotificationResource.pingError(Response.Status.INTERNAL_SERVER_ERROR, "pongRequestFailed", e.getMessage(), pingResponse);
        }
        catch (URISyntaxException e) {
            return NotificationResource.pingError(Response.Status.BAD_REQUEST, "malformedBaseUrl", e.getMessage(), pingResponse);
        }
    }

    private static void logReceive(String what, Object entity) {
        if (log.isDebugEnabled()) {
            String entityString;
            try {
                entityString = OBJECT_MAPPER.writeValueAsString(entity);
            }
            catch (Exception e) {
                try {
                    entityString = "<cannot stringify " + entity + ">";
                }
                catch (Exception e0) {
                    entityString = "<cannot stringify>";
                }
            }
            log.debug("received {} {}", (Object)what, (Object)entityString);
        }
    }

    private static Response pingError(Response.Status status, String errorCode, RestTestResponse response) {
        response.errorCode = errorCode;
        return NotificationResource.error(status, response);
    }

    private static Response pingError(Response.Status status, String errorCode, String details, RestTestResponse response) {
        response.errorCode = errorCode;
        response.errorDetails = details;
        return NotificationResource.error(status, response);
    }

    private static void warnExceptionIfDebug(String msg, Throwable t) {
        if (log.isDebugEnabled()) {
            log.warn(msg, t);
        } else {
            log.warn(msg + ": " + t.getMessage());
        }
    }
}

