/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.rest.jakarta;

import com.almworks.structure.confluence.helper.compat.SpacesQueryBridge;
import com.almworks.structure.confluence.helper.rest.jakarta.AbstractResource;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.Nullable;

@Path(value="/space")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class SpaceResource
extends AbstractResource {
    private final SpaceManager mySpaceManager;
    private final SpaceService mySpaceService;
    private final SpacesQueryBridge mySpacesQueryBridge;

    @Inject
    public SpaceResource(SpaceManager spaceManager, SpaceService spaceService, SpacesQueryBridge spacesQueryBridge) {
        this.mySpaceManager = spaceManager;
        this.mySpaceService = spaceService;
        this.mySpacesQueryBridge = spacesQueryBridge;
    }

    @GET
    public Response getAllSpaces(@QueryParam(value="permission") List<String> permissionParams, @QueryParam(value="fields") List<String> fields) {
        ArrayList<RestPermission> permissions = new ArrayList<RestPermission>();
        for (String permission : permissionParams) {
            RestPermission spacePermission = (RestPermission)EnumUtils.getEnum(RestPermission.class, (String)permission.toUpperCase());
            if (spacePermission == null) {
                return SpaceResource.error(Response.Status.BAD_REQUEST, Collections.singletonMap("message", "Invalid permission requested: " + permission));
            }
            permissions.add(spacePermission);
        }
        ArrayList<RestSpace> spaces = new ArrayList<RestSpace>();
        for (Space space : this.fetchSpaces(permissions)) {
            spaces.add(RestSpace.fromSpace(space));
        }
        return SpaceResource.ok(Collections.singletonMap("spaces", this.getSpaceResponseEntities(spaces, new HashSet<String>(fields))));
    }

    @GET
    @Path(value="/{key}")
    public Response getSpace(@PathParam(value="key") String spaceKey) {
        com.atlassian.confluence.api.model.content.Space space = (com.atlassian.confluence.api.model.content.Space)this.mySpaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOrNull();
        if (space == null) {
            return SpaceResource.error(Response.Status.NOT_FOUND, Collections.singletonMap("message", "Space not found: " + spaceKey));
        }
        return SpaceResource.ok(new RestSpace(space.getId(), space.getKey(), space.getName(), this.getSpaceHomepageId(space)));
    }

    @Nullable
    private Long getSpaceHomepageId(com.atlassian.confluence.api.model.content.Space space) {
        Reference homeRef = space.getHomepageRef();
        if (!homeRef.exists()) {
            return null;
        }
        return ((ContentId)space.getHomepageRef().getIdProperty((Enum)Content.IdProperties.id)).asLong();
    }

    private Collection<Space> fetchSpaces(List<RestPermission> permissions) {
        if (permissions.isEmpty()) {
            return this.fetchSpacesByPermission(RestPermission.VIEW);
        }
        LinkedHashSet<Space> spaces = new LinkedHashSet<Space>();
        for (RestPermission rp : permissions) {
            spaces.addAll(this.fetchSpacesByPermission(rp));
        }
        return spaces;
    }

    private List<Space> fetchSpacesByPermission(RestPermission permission) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        SpacesQuery query = this.mySpacesQueryBridge.forUser(SpacesQuery.newQuery(), user).withPermission(permission.mySpacePermission).build();
        ListBuilder spaces = this.mySpaceManager.getSpaces(query);
        return spaces.getRange(0, spaces.getAvailableSize());
    }

    private List<?> getSpaceResponseEntities(List<RestSpace> spaces, Set<String> fields) {
        if (fields.isEmpty()) {
            return spaces;
        }
        ArrayList<Map> projections = new ArrayList<Map>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (RestSpace space : spaces) {
            Map projection = (Map)objectMapper.convertValue((Object)space, Map.class);
            projection.keySet().retainAll(fields);
            projections.add(projection);
        }
        return projections;
    }

    public static enum RestPermission {
        VIEW("VIEWSPACE"),
        MODIFY("EDITSPACE"),
        ADMIN("SETSPACEPERMISSIONS");

        private final String mySpacePermission;

        private RestPermission(String spacePermission) {
            this.mySpacePermission = spacePermission;
        }
    }

    public static class RestSpace {
        public long id;
        public String key;
        public String name;
        public Long home;

        public RestSpace() {
        }

        public RestSpace(long id, String key, String name, Long home) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.home = home;
        }

        static RestSpace fromSpace(Space space) {
            Long home = space.getHomePage() != null ? Long.valueOf(space.getHomePage().getId()) : null;
            return new RestSpace(space.getId(), space.getKey(), space.getName(), home);
        }
    }
}

