/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.rest.jakarta;

import com.almworks.structure.confluence.helper.rest.data.RestMovePageRequest;
import com.almworks.structure.confluence.helper.rest.data.RestMovePageToSpaceRequest;
import com.almworks.structure.confluence.helper.rest.data.RestPageCreationError;
import com.almworks.structure.confluence.helper.rest.data.RestPageCreationRequest;
import com.almworks.structure.confluence.helper.rest.data.RestPagesValidateAccessRequest;
import com.almworks.structure.confluence.helper.rest.jakarta.AbstractResource;
import com.almworks.structure.confluence.helper.service.StructurePageService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.SpaceService;
import com.atlassian.confluence.content.service.page.MovePageCommand;
import com.atlassian.confluence.content.service.page.MovePageCommandImpl;
import com.atlassian.confluence.content.service.page.MovePageToTopOfSpaceCommand;
import com.atlassian.confluence.content.service.page.PageLocator;
import com.atlassian.confluence.content.service.space.SpaceLocator;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/page")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class PageResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(PageResource.class);
    private final StructurePageService myStructurePageService;
    private final PageService myConfluencePageService;
    private final SpaceService myConfluenceSpaceService;
    private final PageManager myPageManager;
    private final PermissionManager myPermissionManager;
    private final I18nResolver myI18nResolver;

    @Inject
    public PageResource(StructurePageService structurePageService, PageService confluencePageService, SpaceService confluenceSpaceService, PageManager pageManager, PermissionManager permissionManager, I18nResolver i18nResolver) {
        this.myStructurePageService = structurePageService;
        this.myConfluencePageService = confluencePageService;
        this.myConfluenceSpaceService = confluenceSpaceService;
        this.myPageManager = pageManager;
        this.myPermissionManager = permissionManager;
        this.myI18nResolver = i18nResolver;
    }

    @POST
    @Path(value="/create")
    public Response createPage(RestPageCreationRequest request) {
        Long pageId;
        String contentType;
        if (request.ancestors == null || request.ancestors.get(0) == null || request.ancestors.get(0).getId() == null) {
            return this.creationError("Parent page cannot be empty.");
        }
        if (request.space == null || StringUtils.isEmpty((CharSequence)request.space.getKey())) {
            return this.creationError("Space cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)request.contentId)) {
            return this.creationError("ContentId cannot be empty. Specify a valid template id or blueprint id");
        }
        if (StringUtils.isEmpty((CharSequence)request.title)) {
            return this.creationError("Page title cannot be empty.");
        }
        if (StringUtils.isEmpty((CharSequence)request.contentType)) {
            return this.creationError("Content type cannot be empty. Valid types are BLUEPRINT, TEMPLATE.");
        }
        String spaceKey = request.space.getKey();
        String contentId = request.contentId;
        String title = request.title;
        long parentPageId = request.ancestors.get(0).getId().asLong();
        switch (contentType = StringUtils.upperCase((String)request.contentType)) {
            case "BLUEPRINT": {
                try {
                    pageId = this.myStructurePageService.createBlueprintPage(title, contentId, spaceKey, parentPageId);
                    break;
                }
                catch (BlueprintIllegalArgumentException e) {
                    return this.creationError("Invalid blueprint id: " + contentId + ", error msg: " + e.getMessage());
                }
                catch (Exception e) {
                    return this.creationError(e.getMessage());
                }
            }
            case "TEMPLATE": {
                long templateId;
                try {
                    templateId = Long.parseLong(contentId);
                }
                catch (NumberFormatException e) {
                    return this.creationError("Invalid template id: " + contentId);
                }
                try {
                    pageId = this.myStructurePageService.createTemplatePage(title, templateId, spaceKey, parentPageId);
                    break;
                }
                catch (Exception e) {
                    return this.creationError(e.getMessage());
                }
            }
            default: {
                return this.creationError("Unrecognized content type. Valid types are BLUEPRINT, TEMPLATE.");
            }
        }
        if (pageId == null) {
            return this.creationError("Unable to create a page.");
        }
        return PageResource.ok(Collections.singletonMap("id", pageId));
    }

    @POST
    @Path(value="/validateAccess")
    @ReadOnlyAccessAllowed
    public Response getVisiblePages(RestPagesValidateAccessRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Page page : this.myPageManager.getPages(request.pageIds)) {
            if (page.isDeleted() || !page.isIndexable()) continue;
            pages.add(page);
        }
        List visiblePages = this.myPermissionManager.getPermittedEntities((User)user, Permission.VIEW, pages);
        ArrayList<Long> visibleIds = new ArrayList<Long>();
        for (Page page : visiblePages) {
            visibleIds.add(page.getId());
        }
        return PageResource.ok(Collections.singletonMap("visiblePageIds", visibleIds));
    }

    @POST
    @Path(value="/move")
    public Response movePage(RestMovePageRequest request) {
        PageLocator sourcePage = this.myConfluencePageService.getIdPageLocator(request.sourcePageId);
        PageLocator targetPage = this.myConfluencePageService.getIdPageLocator(request.targetPageId);
        return this.executeServiceCommand((ServiceCommand)this.movePageCommand(sourcePage, targetPage, request.position));
    }

    @POST
    @Path(value="/moveToSpace")
    public Response movePageToTop(RestMovePageToSpaceRequest request) {
        PageLocator page = this.myConfluencePageService.getIdPageLocator(request.pageId);
        SpaceLocator space = this.myConfluenceSpaceService.getKeySpaceLocator(request.spaceKey);
        return this.executeServiceCommand((ServiceCommand)this.moveToSpaceCommand(page, space));
    }

    @NotNull
    private MovePageCommand movePageCommand(PageLocator sourcePage, PageLocator targetPage, String position) {
        return new MovePageCommandImpl(this.myPageManager, this.myPermissionManager, sourcePage, targetPage, position);
    }

    @NotNull
    private MovePageCommand moveToSpaceCommand(PageLocator sourcePageLocator, SpaceLocator targetSpaceLocator) {
        return new MovePageToTopOfSpaceCommand(this.myPageManager, this.myPermissionManager, sourcePageLocator, targetSpaceLocator);
    }

    private Response executeServiceCommand(@NotNull ServiceCommand command) {
        try {
            command.execute();
            return PageResource.noContent();
        }
        catch (NotAuthorizedException nae) {
            logger.error("Unable to perform the operation", (Throwable)nae);
            return PageResource.error(Response.Status.UNAUTHORIZED, Collections.singletonMap("message", "Unable to perform the operation"));
        }
        catch (NotValidException nve) {
            String message = command.getValidationErrors().stream().map(e -> this.myI18nResolver.getText(e.getMessageKey(), new Serializable[]{e.getArgs()})).collect(Collectors.joining(". "));
            logger.error(message, (Throwable)nve);
            return PageResource.error(Response.Status.BAD_REQUEST, Collections.singletonMap("message", message));
        }
    }

    @NotNull
    private Response creationError(@NotNull String message) {
        RestPageCreationError creationError = new RestPageCreationError();
        creationError.message = message;
        return PageResource.error(Response.Status.INTERNAL_SERVER_ERROR, creationError);
    }
}

