/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import com.almworks.integers.LongSetBuilder;
import com.almworks.structure.confluence.helper.rest.data.RestNotification;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestNotificationBuilder {
    private final LongSetBuilder myPagesChanged;
    private final LongSetBuilder myPagesVisibilityChanged;
    private Set<String> mySpacesVisibilityChanged;
    private Set<String> myUsersChanged;
    private Set<String> mySpacesChanged;
    private boolean myIsAllVisibilitiesChanged;
    private boolean myIsAllSpacesChanged;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public RestNotificationBuilder(int nNotifications) {
        this.myPagesChanged = RestNotificationBuilder.longSetBuilder(nNotifications);
        this.myPagesVisibilityChanged = RestNotificationBuilder.longSetBuilder(nNotifications);
        this.mySpacesChanged = new LinkedHashSet<String>();
        this.mySpacesVisibilityChanged = new LinkedHashSet<String>();
        this.myUsersChanged = new LinkedHashSet<String>();
        this.myIsAllVisibilitiesChanged = false;
        this.myIsAllSpacesChanged = false;
    }

    private static LongSetBuilder longSetBuilder(int sizeUpperEstimate) {
        return sizeUpperEstimate < 16 ? new LongSetBuilder(16) : new LongSetBuilder();
    }

    public void addPageChanged(long pageId) {
        this.myPagesChanged.add(pageId);
    }

    public void addPageVisibilityChanged(long pageId) {
        this.myPagesVisibilityChanged.add(pageId);
    }

    public void addSpaceChanged(@NotNull String spaceKey) {
        this.mySpacesChanged.add(spaceKey);
    }

    public void addSpaceVisibilityChanged(@NotNull String spaceKey) {
        this.mySpacesVisibilityChanged.add(spaceKey);
    }

    public void addUserChanged(@Nullable String userKey) {
        this.myUsersChanged.add(userKey == null ? "" : userKey);
    }

    public void addAllVisibilitiesChanged() {
        this.myIsAllVisibilitiesChanged = true;
    }

    public void addAllSpacesChanged() {
        this.myIsAllSpacesChanged = true;
    }

    public RestNotification build() {
        RestNotification dest = new RestNotification();
        dest.pagesChanged = RestNotificationBuilder.toArray(this.myPagesChanged);
        dest.pagesVisibilityChanged = RestNotificationBuilder.toArray(this.myPagesVisibilityChanged);
        dest.spacesChanged = RestNotificationBuilder.toArray(this.mySpacesChanged);
        dest.spacesVisibilityChanged = RestNotificationBuilder.toArray(this.mySpacesVisibilityChanged);
        dest.usersChanged = RestNotificationBuilder.toArray(this.myUsersChanged);
        dest.isAllVisibilitiesChanged = this.myIsAllVisibilitiesChanged;
        dest.isAllSpacesChanged = this.myIsAllSpacesChanged;
        return dest;
    }

    @Nullable
    private static long[] toArray(LongSetBuilder builder) {
        return builder.isEmpty() ? null : builder.commitToArray().toNativeArray();
    }

    private static String[] toArray(Set<String> set) {
        return set.isEmpty() ? null : set.toArray(new String[0]);
    }

    public RestNotificationBuilder mergeValues(RestNotification src) {
        this.myPagesChanged.mergeFromSortedCollection((LongList)new LongArray(src.pagesChanged));
        this.myPagesVisibilityChanged.mergeFromSortedCollection((LongList)new LongArray(src.pagesVisibilityChanged));
        this.mySpacesChanged = this.mergeSetValues(this.mySpacesChanged, src.spacesChanged);
        this.mySpacesVisibilityChanged = this.mergeSetValues(this.mySpacesVisibilityChanged, src.spacesVisibilityChanged);
        this.myUsersChanged = this.mergeSetValues(this.myUsersChanged, src.usersChanged);
        this.myIsAllVisibilitiesChanged |= src.isAllVisibilitiesChanged;
        this.myIsAllSpacesChanged |= src.isAllSpacesChanged;
        return this;
    }

    private Set<String> mergeSetValues(Set<String> source, String[] newValues) {
        LinkedHashSet<String> merged = new LinkedHashSet<String>(source);
        Collections.addAll(merged, RestNotificationBuilder.nnarr(newValues));
        return merged;
    }

    private static String[] nnarr(String[] arr) {
        return arr == null ? EMPTY_STRING_ARRAY : arr;
    }
}

