define('structure/macro/StructureMacroConfig', ['structure/macro/MacroFields'], function (MacroFields) {
  'use strict';

  const mfs = MacroFields.createMacroFields('/rest/structure-helper/1.0/macro/settings');
  mfs.onUpdateFields(function (appLink, data, restoredValues) {
    mfs.assignOptions(mfs.fields.applink, data?.applinks, restoredValues?.applink || appLink);
    mfs.assignOptions(mfs.fields.structure, data?.structures, restoredValues?.structure);
    mfs.assignOptions(mfs.fields.view, data?.views, restoredValues?.view, {
      key: '0', value: WRM.I18n.getText('structuremacro.view.default')
    });
    mfs.assignOptions(mfs.fields.savedfilter, data?.savedfilters, restoredValues?.savedfilter);

    if (restoredValues?.filtertype === 'saved' && !restoredValues?.savedfilter) {
      mfs.fields.filtertype.input.val('none');
      mfs.fields.filtertype.input.auiSelect2();
    }
    mfs.updateStructureName();

    mfs.fields.applink?.input?.prop('disabled', !data?.applinks);
    mfs.fields.savedfilter?.input?.prop('disabled', !data?.savedfilters);
    mfs.toggleField(mfs.fields.structure, data?.structures);
    mfs.toggleField(mfs.fields.view, data?.views);
    mfs.toggleField(mfs.fields.filtertype, data?.structures);
    mfs.toggleFilterFields(data?.structures && mfs.fields.filtertype?.input?.val());
  });

  function initialize() {
    mfs.macroBrowser().setMacroJsOverride('structuremacro', {
      fields: {
        enum: {
          applink: mfs.setupAppLinksSelector('applink'),
          structure: mfs.setupSelect('structure', field => {
            field.input.on('change', () => mfs.updateStructureName());
          }),
          view: mfs.setupSelect('view'),
          filtertype: mfs.setupSelect('filtertype', field => {
            field.input.on('change', () => mfs.toggleFilterFields(field.input.val()));
            setTimeout(() => mfs.toggleFilterFields(field.getValue()));
            setTimeout(() => field.input.auiSelect2());
          }),
          savedfilter: mfs.setupSelect('savedfilter')
        },
        string: {
          textfilter: mfs.setupTextArea('textfilter'),
          jqlfilter: mfs.setupTextArea('jqlfilter'),
          sjqlfilter: mfs.setupTextArea('sjqlfilter'),
          title: mfs.setupField('title', 'string'),
          width: mfs.setupSizeField('width', 'string'),
          height: mfs.setupSizeField('height', 'string'),
          structurename: mfs.setupField0('structurename', '_hidden')
        },
        boolean: {
          editable: mfs.setupField('editable', 'boolean')
        }
      }
    });
  }

  return {
    initialize
  };
});
