/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GanttChartOption {
    ISSUE_KEY(0, "issueKey"),
    SUMMARY(1, "summary"),
    RESOURCE_ASSIGNMENT(2, "resourceAssignment"),
    CRITICAL_PATH(3, "criticalPath"),
    PROGRESS(4, "progress"),
    DEPENDENCIES(5, "dependencies"),
    CHART_WARNINGS(6, "chartWarnings"),
    SCHEDULING_CONFLICT(6, "schedulingConflict"),
    PROJECT_START_DAY(7, "projectStartDay"),
    TODAY_MARKER(8, "todayMarker"),
    FIX_VERSION_MARKERS(9, "fixVersionMarkers"),
    TASK_INDICATORS(11, "taskIndicators"),
    TASK_ICONS(11, "taskIcons"),
    BASELINE_DELAYS(12, "baselineDelays"),
    CUSTOM_MARKERS(15, "customMarkers"),
    SHOW_SAFE_VIEW(18, "showSafeView");

    public final int id;
    public final String name;

    private GanttChartOption(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public static List<GanttChartOption> getOptionsForVersion(@Nullable String version) {
        ExclusionChecker checker = new ExclusionChecker(version);
        return Arrays.stream(GanttChartOption.values()).filter(x$0 -> checker.isNotExcludedOption(x$0)).collect(Collectors.toList());
    }

    private static class ExclusionChecker {
        private final String myVersion;

        ExclusionChecker(@Nullable String version) {
            this.myVersion = version;
        }

        private boolean isNotExcludedOption(GanttChartOption option) {
            if (this.myVersion == null) {
                return option != SCHEDULING_CONFLICT && option != TASK_ICONS;
            }
            return option != CHART_WARNINGS && option != TASK_INDICATORS;
        }
    }
}

