/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.rest;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.almworks.structure.confluence.macro.MacroSettingsLoader;
import com.almworks.structure.confluence.macro.MacroSettingsLoaderFactory;
import com.almworks.structure.confluence.macro.rest.RestSettings;
import com.almworks.structure.confluence.macro.util.JacksonUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/macro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class StructureMacroResource
extends AbstractResource {
    private final ObjectMapper objectMapper = JacksonUtils.defaultMapper();
    private final MacroSettingsLoader<RestSettings> mySettingsLoader;

    @Inject
    public StructureMacroResource(MacroSettingsLoaderFactory structureSettingsLoaderFactory) {
        this.mySettingsLoader = structureSettingsLoaderFactory.createLoader("structuremacro", "/rest/structure/2.0/macro/settings", RestSettings::new, this::populateFromResponse);
    }

    @GET
    @Path(value="/settings")
    public Response settings(@QueryParam(value="link") String appLinkId) {
        return StructureMacroResource.ok(this.mySettingsLoader.loadSettings(appLinkId));
    }

    private void populateFromResponse(RestSettings settings, com.atlassian.sal.api.net.Response response) throws ResponseException, JsonProcessingException {
        String responseString = response.getResponseBodyAsString();
        RestSettings jiraData = (RestSettings)this.objectMapper.readValue(responseString, RestSettings.class);
        settings.structures = jiraData.structures;
        settings.views = jiraData.views;
        settings.savedfilters = jiraData.savedfilters;
        settings.error = jiraData.error;
    }
}

