/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.AbstractMacro;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.MacroUtil;
import com.almworks.structure.confluence.macro.parameter.CommonMacroParameters;
import com.almworks.structure.confluence.macro.parameter.MacroParameter;
import com.almworks.structure.confluence.macro.rest.GanttPingResponse;
import com.almworks.structure.confluence.macro.util.GanttChartOption;
import com.almworks.structure.confluence.macro.util.JacksonUtils;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GanttMacro
extends AbstractMacro {
    private static final Logger log = LoggerFactory.getLogger(GanttMacro.class);
    private static final Set<String> FILTER_TYPES = new HashSet<String>(Arrays.asList("none", "text", "jql", "sjql"));
    private static final Pattern BASELINE_PATTERN = Pattern.compile("g?[0-9]+");
    private final List<MacroParameter> myParameters;
    private final Map<String, Long> myRefreshIntervals = new HashMap<String, Long>();
    private final ObjectMapper objectMapper = JacksonUtils.defaultMapper();

    public GanttMacro(MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        super("ganttmacro", appLinkClient, i18nResolver);
        this.createRefreshIntervals();
        MacroParameter[] macroParameterArray = new MacroParameter[21];
        macroParameterArray[0] = CommonMacroParameters.macroSize("width", "100%");
        macroParameterArray[1] = new MacroParameter("height", false, "300", CommonMacroParameters::validatePixelSize, Function.identity());
        macroParameterArray[2] = new MacroParameter("applink", true, v -> this.myAppLinkClient.getJiraLink((String)v) != null);
        macroParameterArray[3] = new MacroParameter("structure", true, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        macroParameterArray[4] = new MacroParameter("hierarchyLevel", false, "0", v -> LONG_PATTERN.matcher((CharSequence)v).matches(), Function.identity());
        macroParameterArray[5] = new MacroParameter("structurename");
        macroParameterArray[6] = new MacroParameter("timelineZoom", true, "days", v -> !v.isEmpty(), Function.identity());
        macroParameterArray[7] = new MacroParameter("timelineMode", true, "0", v -> !v.isEmpty(), Function.identity());
        macroParameterArray[8] = new MacroParameter("todayOffset", false, "0", v -> LONG_PATTERN.matcher((CharSequence)v).matches(), Function.identity());
        macroParameterArray[9] = CommonMacroParameters.date("fixedStartDate", "yyyy-MM-dd");
        macroParameterArray[10] = new MacroParameter("fiscalYearStartMonth", false, "-1", this::isValidYearStartMonth, Function.identity());
        macroParameterArray[11] = new MacroParameter("filtertype", false, "none", FILTER_TYPES::contains, Function.identity());
        macroParameterArray[12] = new MacroParameter("savedfilter", false, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        macroParameterArray[13] = new MacroParameter("textfilter");
        macroParameterArray[14] = new MacroParameter("jqlfilter");
        macroParameterArray[15] = new MacroParameter("sjqlfilter");
        macroParameterArray[16] = new MacroParameter("baseline", false, "0", v -> BASELINE_PATTERN.matcher((CharSequence)v).matches(), Function.identity());
        macroParameterArray[17] = new MacroParameter("sandbox", false, "0", v -> LONG_PATTERN.matcher((CharSequence)v).matches(), Function.identity());
        macroParameterArray[18] = CommonMacroParameters.pixelsOrAuto("wbsWidth", "0");
        macroParameterArray[19] = new MacroParameter("refreshInterval", false, "never", this.myRefreshIntervals::containsKey, Function.identity());
        macroParameterArray[20] = new MacroParameter("wbs");
        this.myParameters = Arrays.asList(macroParameterArray);
    }

    public String execute(Map<String, String> formParams, String s, ConversionContext conversionContext) {
        ArrayList<String> errors = new ArrayList<String>();
        Map<String, Object> parsedFormParams = this.prepareFormParams(formParams, conversionContext, errors);
        Map<String, Object> velocityParams = this.prepareVelocityParams(parsedFormParams, errors);
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/gantt-macro.vm", velocityParams);
    }

    private Map<String, Object> prepareFormParams(Map<String, String> formParams, ConversionContext conversionContext, List<String> errors) {
        HashMap<String, Object> parsedFormParams = new HashMap<String, Object>();
        this.parseParameters(this.myParameters, formParams, parsedFormParams, errors);
        ReadOnlyApplicationLink appLink = this.myAppLinkClient.getJiraLink((String)parsedFormParams.get("applink"));
        GanttInfo ganttInfo = GanttInfo.EMPTY;
        if (appLink != null) {
            ganttInfo = this.getGanttInfo(appLink);
            parsedFormParams.put("ganttInstalled", ganttInfo.installed);
            parsedFormParams.put("ganttVersion", ganttInfo.version);
        }
        parsedFormParams.put("id", this.getMacroId(conversionContext));
        parsedFormParams.put("wbs", !"false".equals(formParams.get("wbs")));
        parsedFormParams.put("chartOptions", this.getChartOptions(formParams, ganttInfo.version));
        parsedFormParams.put("query", formParams.get(formParams.get("filtertype") + "filter"));
        return parsedFormParams;
    }

    private Map<String, Object> prepareVelocityParams(Map<String, Object> parsedFormParams, List<String> errors) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("alttitle", this.myI18nResolver.getText("structuremacro.error.no-structure.title"));
        velocityParams.put("available", errors.isEmpty());
        velocityParams.put("errors", errors);
        velocityParams.put("title", this.getMacroTitle((String)parsedFormParams.get("structurename")));
        velocityParams.put("width", parsedFormParams.get("width"));
        velocityParams.put("height", parsedFormParams.get("height"));
        velocityParams.put("refreshIntervalMills", this.myRefreshIntervals.getOrDefault((String)parsedFormParams.get("refreshInterval"), 0L));
        ReadOnlyApplicationLink appLink = this.myAppLinkClient.getJiraLink((String)parsedFormParams.get("applink"));
        if (appLink != null && errors.isEmpty()) {
            if (Boolean.FALSE.equals(parsedFormParams.get("ganttInstalled"))) {
                velocityParams.put("available", false);
                errors.add(this.myI18nResolver.getText("ganttmacro.error.not-installed"));
            } else {
                String macroUrl = this.buildMacroUrl(appLink.getRpcUrl().toString(), parsedFormParams);
                velocityParams.put("macroUrl", macroUrl);
            }
        }
        if (!errors.isEmpty()) {
            velocityParams.put("height", parsedFormParams.getOrDefault("height", "300") + "px");
        }
        return velocityParams;
    }

    private String buildMacroUrl(String appLinkUrl, Map<String, Object> parsedFormParams) {
        LinkedHashMap<String, Object> urlParams = new LinkedHashMap<String, Object>();
        urlParams.put("structureId", parsedFormParams.get("structure"));
        urlParams.put("gadgetid", parsedFormParams.get("id"));
        urlParams.put("wbs", parsedFormParams.get("wbs"));
        urlParams.put("wbsMaxWidth", parsedFormParams.get("wbsWidth"));
        urlParams.put("width", parsedFormParams.get("width"));
        urlParams.put("zoomLevel", parsedFormParams.get("timelineZoom"));
        urlParams.put("timelineMode", parsedFormParams.get("timelineMode"));
        urlParams.put("chartOptions", parsedFormParams.get("chartOptions"));
        urlParams.put("hierarchyLevel", parsedFormParams.get("hierarchyLevel"));
        urlParams.put("todayOffset", parsedFormParams.get("todayOffset"));
        urlParams.put("fixedStartDate", parsedFormParams.get("fixedStartDate"));
        urlParams.put("height", parsedFormParams.get("height"));
        urlParams.put("fiscalYearStartMonth", parsedFormParams.get("fiscalYearStartMonth"));
        urlParams.put("baselineId", parsedFormParams.get("baseline"));
        urlParams.put("sandboxId", parsedFormParams.get("sandbox"));
        urlParams.put("filterQuery", parsedFormParams.get("query"));
        urlParams.put("filterType", parsedFormParams.get("filtertype"));
        return MacroUtil.buildUrlWithParams(appLinkUrl + "/secure/GanttExternalGadget.jspa", urlParams);
    }

    @NotNull
    private String getChartOptions(Map<String, String> map, @Nullable String version) {
        ArrayList<String> result = new ArrayList<String>();
        for (GanttChartOption option : GanttChartOption.getOptionsForVersion(version)) {
            if ("false".equals(map.get(option.name))) continue;
            result.add(String.valueOf(option.id));
        }
        return String.join((CharSequence)"|", result);
    }

    private void createRefreshIntervals() {
        this.myRefreshIntervals.put("never", 0L);
        this.myRefreshIntervals.put("every15minutes", TimeUnit.MINUTES.toMillis(15L));
        this.myRefreshIntervals.put("every30minutes", TimeUnit.MINUTES.toMillis(30L));
        this.myRefreshIntervals.put("everyHour", TimeUnit.HOURS.toMillis(1L));
        this.myRefreshIntervals.put("every2Hours", TimeUnit.HOURS.toMillis(2L));
    }

    private boolean isValidYearStartMonth(String input) {
        try {
            int value = Integer.parseInt(input);
            return value >= -1 && value <= 11;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    private GanttInfo getGanttInfo(@NotNull ReadOnlyApplicationLink appLink) {
        try {
            ApplicationLinkRequestFactory factory = appLink.createAuthenticatedRequestFactory();
            Response response = this.myAppLinkClient.get(factory, "/rest/structure-gantt/1.0/ganttmacro/ping");
            if (response.isSuccessful()) {
                String responseString = response.getResponseBodyAsString();
                GanttPingResponse pingResponse = (GanttPingResponse)this.objectMapper.readValue(responseString, GanttPingResponse.class);
                return new GanttInfo(Boolean.TRUE.equals(pingResponse.ganttInstalled), pingResponse.ganttVersion);
            }
            log.debug("Gantt.Macro got unexpected response from Jira server: status={}, body='{}'", (Object)response.getStatusCode(), (Object)response.getResponseBodyAsString());
        }
        catch (ResponseException e) {
            log.warn("response exception while checking if Gantt is installed", (Throwable)e);
        }
        catch (CredentialsRequiredException | RuntimeException e) {
            log.warn("cannot check whether the gantt plugin with correct version is installed", e);
        }
        catch (JsonProcessingException e) {
            log.warn("cannot parse ping response from Gantt chart", (Throwable)e);
        }
        return GanttInfo.EMPTY;
    }

    private static class GanttInfo {
        private static final GanttInfo EMPTY = new GanttInfo(false, null);
        public boolean installed;
        public String version;

        public GanttInfo(boolean installed, @Nullable String version) {
            this.installed = installed;
            this.version = version;
        }
    }
}

