/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.security;

import com.almworks.structure.commons.security.CookieAttributeAppender;
import com.almworks.structure.commons.security.SecurityInterceptorEnhancer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSiteCookieAttributeFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SameSiteCookieAttributeFilter.class);

    public void init(@NotNull FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ("https".equalsIgnoreCase(request.getScheme()) && response instanceof HttpServletResponse && request instanceof HttpServletRequest && SecurityInterceptorEnhancer.hasOurCookie((HttpServletRequest)((HttpServletRequest)request))) {
            chain.doFilter(request, (ServletResponse)new SameSiteCookieWrapper((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    private class SameSiteCookieWrapper
    extends HttpServletResponseWrapper {
        @NotNull
        private final HttpServletResponse myResponse;

        public SameSiteCookieWrapper(HttpServletResponse response) {
            super(response);
            this.myResponse = response;
        }

        public void sendRedirect(String location) throws IOException {
            SameSiteCookieAttributeFilter.this.logger.debug("sendRedirect(String) called");
            CookieAttributeAppender.appendCookieAttributes((HttpServletResponse)this.myResponse, (CookieAttributeAppender.CookieAttribute[])new CookieAttributeAppender.CookieAttribute[]{CookieAttributeAppender.CookieAttribute.SAME_SITE_NONE, CookieAttributeAppender.CookieAttribute.SECURE});
            super.sendRedirect(location);
        }
    }
}

