/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.rest;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.almworks.structure.confluence.helper.rest.RestPageCreationError;
import com.almworks.structure.confluence.helper.rest.RestPageCreationRequest;
import com.almworks.structure.confluence.helper.rest.RestPagesValidateAccessRequest;
import com.almworks.structure.confluence.helper.service.StructurePageService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Path(value="/page")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class PageResource
extends AbstractResource {
    private final StructurePageService myPageService;
    private final PageManager myPageManager;
    private final PermissionManager myPermissionManager;

    @Inject
    public PageResource(StructurePageService pageService, PageManager pageManager, PermissionManager permissionManager) {
        this.myPageService = pageService;
        this.myPageManager = pageManager;
        this.myPermissionManager = permissionManager;
    }

    @POST
    @Path(value="/create")
    public Response createPage(RestPageCreationRequest request) {
        Long pageId;
        String contentType;
        if (request.ancestors == null || request.ancestors.get(0) == null || request.ancestors.get(0).getId() == null) {
            return this.creationError("Parent page cannot be empty.");
        }
        if (request.space == null || StringUtils.isEmpty((CharSequence)request.space.getKey())) {
            return this.creationError("Space cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)request.contentId)) {
            return this.creationError("ContentId cannot be empty. Specify a valid template id or blueprint id");
        }
        if (StringUtils.isEmpty((CharSequence)request.title)) {
            return this.creationError("Page title cannot be empty.");
        }
        if (StringUtils.isEmpty((CharSequence)request.contentType)) {
            return this.creationError("Content type cannot be empty. Valid types are BLUEPRINT, TEMPLATE.");
        }
        String spaceKey = request.space.getKey();
        String contentId = request.contentId;
        String title = request.title;
        long parentPageId = request.ancestors.get(0).getId().asLong();
        switch (contentType = StringUtils.upperCase((String)request.contentType)) {
            case "BLUEPRINT": {
                try {
                    pageId = this.myPageService.createBlueprintPage(title, contentId, spaceKey, parentPageId);
                    break;
                }
                catch (BlueprintIllegalArgumentException e) {
                    return this.creationError("Invalid blueprint id: " + contentId + ", error msg: " + e.getMessage());
                }
                catch (Exception e) {
                    return this.creationError(e.getMessage());
                }
            }
            case "TEMPLATE": {
                long templateId;
                try {
                    templateId = Long.parseLong(contentId);
                }
                catch (NumberFormatException e) {
                    return this.creationError("Invalid template id: " + contentId);
                }
                try {
                    pageId = this.myPageService.createTemplatePage(title, templateId, spaceKey, parentPageId);
                    break;
                }
                catch (Exception e) {
                    return this.creationError(e.getMessage());
                }
            }
            default: {
                return this.creationError("Unrecognized content type. Valid types are BLUEPRINT, TEMPLATE.");
            }
        }
        if (pageId == null) {
            return this.creationError("Unable to create a page.");
        }
        return PageResource.ok(Collections.singletonMap("id", pageId));
    }

    @POST
    @Path(value="/validateAccess")
    @ReadOnlyAccessAllowed
    public Response getVisiblePages(RestPagesValidateAccessRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Page page : this.myPageManager.getPages(request.pageIds)) {
            if (page.isDeleted() || !page.isIndexable()) continue;
            pages.add(page);
        }
        List visiblePages = this.myPermissionManager.getPermittedEntities((User)user, Permission.VIEW, pages);
        ArrayList<Long> visibleIds = new ArrayList<Long>();
        for (Page page : visiblePages) {
            visibleIds.add(page.getId());
        }
        return PageResource.ok(Collections.singletonMap("visiblePageIds", visibleIds));
    }

    @NotNull
    private Response creationError(@NotNull String message) {
        RestPageCreationError creationError = new RestPageCreationError();
        creationError.message = message;
        return PageResource.error(Response.Status.INTERNAL_SERVER_ERROR, creationError);
    }
}

