/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.cluster;

import com.almworks.structure.confluence.helper.AppLinkClient;
import com.almworks.structure.confluence.helper.SubscriptionManager;
import com.almworks.structure.confluence.helper.cluster.PagesSubscriptionEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEventListener {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionEventListener.class);
    private final SubscriptionManager mySubscriptionManager;

    public SubscriptionEventListener(SubscriptionManager subscriptionManager) {
        this.mySubscriptionManager = subscriptionManager;
    }

    @EventListener
    public void handleLocalEvent(PagesSubscriptionEvent event) {
    }

    @EventListener
    public void handleRemoteEvent(ClusterEventWrapper wrapper) {
        try {
            Object event = wrapper.getClass().getMethod("getEvent", new Class[0]).invoke((Object)wrapper, new Object[0]);
            if (event instanceof PagesSubscriptionEvent) {
                PagesSubscriptionEvent subscriptionEvent = (PagesSubscriptionEvent)event;
                this.mySubscriptionManager.subscribe(new URI(subscriptionEvent.getBaseUrl()), "/rest/structure-pages/1.0/notification", subscriptionEvent.getAppLinkId(), subscriptionEvent.getTimeToLiveMillis());
            }
        }
        catch (AppLinkClient.NoAppLinkException e) {
            log.error("Unable to find an AppLink", (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error("Malformed base URL: ", (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            log.error("Reflection error calling getEvent: ", (Throwable)e);
        }
    }
}

