/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.util.RemoteResponse;
import com.almworks.structure.confluence.helper.util.RemoteResponseAnonymousAppLinkHandler;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLinkClient {
    private static final Logger log = LoggerFactory.getLogger(AppLinkClient.class);
    private final ReadOnlyApplicationLinkService myLinkService;

    public AppLinkClient(ReadOnlyApplicationLinkService linkService) {
        this.myLinkService = linkService;
    }

    public static <R> RemoteResponse<R> anonymousPost(ReadOnlyApplicationLink link, String url, Object requestEntity, Class<R> responseClass) throws CredentialsRequiredException, ResponseException {
        return (RemoteResponse)AppLinkClient.post(link, url, requestEntity, new RemoteResponseAnonymousAppLinkHandler<R>(responseClass), Anonymous.class);
    }

    public static <T> T post(ReadOnlyApplicationLink link, String url, Object entity, ApplicationLinkResponseHandler<T> handler, Class<? extends AuthenticationProvider> authProvider) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory factory = link.createAuthenticatedRequestFactory(authProvider);
        ApplicationLinkRequest request = factory.createRequest(Request.MethodType.POST, url);
        request.setHeader("Content-Type", "application/json");
        request.setEntity(entity);
        return (T)request.execute(handler);
    }

    public ReadOnlyApplicationLink findLink(URI remoteAppBaseUrl) throws NoAppLinkException {
        try {
            return this.findLinkByLongestPrefixMatch(remoteAppBaseUrl, ReadOnlyApplicationLink::getRpcUrl);
        }
        catch (NoAppLinkException e) {
            log.warn("Trying application link display URIs");
            return this.findLinkByLongestPrefixMatch(remoteAppBaseUrl, ReadOnlyApplicationLink::getDisplayUrl);
        }
    }

    private ReadOnlyApplicationLink findLinkByLongestPrefixMatch(URI remoteAppBaseUrl, Function<ReadOnlyApplicationLink, URI> linkToUri) throws NoAppLinkException {
        String remoteAppBaseUriNorm = AppLinkClient.normalize(remoteAppBaseUrl);
        Iterable applicationLinks = this.myLinkService.getApplicationLinks();
        for (ReadOnlyApplicationLink candidateLink : applicationLinks) {
            String candidateUri = AppLinkClient.normalize(linkToUri.apply(candidateLink));
            if (!remoteAppBaseUriNorm.startsWith(candidateUri)) continue;
            return candidateLink;
        }
        if (log.isWarnEnabled()) {
            String candidateUris = StreamSupport.stream(applicationLinks.spliterator(), false).map(linkToUri).map(URI::toString).collect(Collectors.joining(", "));
            log.warn("Cannot find application link for remote base URL {}. Candidate URIs: {}", (Object)remoteAppBaseUrl, (Object)candidateUris);
        }
        throw new NoAppLinkException();
    }

    private static String normalize(URI uri) {
        uri = uri.normalize();
        try {
            uri = new URI(null, null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            log.warn("normalize failed for " + uri, (Throwable)e);
        }
        return uri.toASCIIString().toLowerCase(Locale.ROOT);
    }

    public static class NoAppLinkException
    extends Exception {
    }
}

