/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.rest;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.almworks.structure.confluence.macro.MacroSettingsLoader;
import com.almworks.structure.confluence.macro.MacroSettingsLoaderFactory;
import com.almworks.structure.confluence.macro.rest.GanttAdditionalRestSettings;
import com.almworks.structure.confluence.macro.rest.GanttRestSettings;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/ganttmacro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class GanttMacroResource
extends AbstractResource {
    private static final String MACRO_KEY = "ganttmacro";
    private final MacroSettingsLoader<GanttRestSettings> mySettingsLoader;
    private final MacroSettingsLoader<GanttAdditionalRestSettings> myAdditionalSettingsLoader;

    @Inject
    public GanttMacroResource(MacroSettingsLoaderFactory settingsLoaderFactory) {
        this.mySettingsLoader = settingsLoaderFactory.createLoader(MACRO_KEY, "/rest/structure-gantt/1.0/ganttmacro/settings", GanttRestSettings::new, this::populateFromResponse);
        this.myAdditionalSettingsLoader = settingsLoaderFactory.createLoader(MACRO_KEY, "/rest/structure-gantt/1.0/ganttmacro/additionalsettings", GanttAdditionalRestSettings::new, this::populateAdditionalSettingsFromResponse);
    }

    @GET
    @Path(value="/settings")
    public Response settings(@QueryParam(value="link") String appLinkId) {
        return GanttMacroResource.ok(this.mySettingsLoader.loadSettings(appLinkId));
    }

    @GET
    @Path(value="/additionalsettings")
    public Response additionalSettings(@QueryParam(value="link") String appLinkId, @QueryParam(value="structureId") Long structureId) {
        Map<String, String> params = structureId == null ? Collections.emptyMap() : Collections.singletonMap("structureId", structureId.toString());
        return GanttMacroResource.ok(this.myAdditionalSettingsLoader.loadSettings(appLinkId, params));
    }

    private void populateFromResponse(GanttRestSettings settings, com.atlassian.sal.api.net.Response response) throws ResponseException {
        GanttRestSettings jiraData = (GanttRestSettings)response.getEntity(GanttRestSettings.class);
        settings.structures = jiraData.structures;
        settings.zoomLevels = jiraData.zoomLevels;
        settings.timelineModes = jiraData.timelineModes;
        settings.yearStartOptions = jiraData.yearStartOptions;
        settings.error = jiraData.error;
    }

    private void populateAdditionalSettingsFromResponse(GanttAdditionalRestSettings settings, com.atlassian.sal.api.net.Response response) throws ResponseException {
        GanttAdditionalRestSettings jiraData = (GanttAdditionalRestSettings)response.getEntity(GanttAdditionalRestSettings.class);
        settings.noBaselineOption = jiraData.noBaselineOption;
        settings.originalScheduleOption = jiraData.originalScheduleOption;
        settings.baselines = jiraData.baselines;
        settings.noSandboxOption = jiraData.noSandboxOption;
        settings.sandboxes = jiraData.sandboxes;
        settings.error = jiraData.error;
    }
}

