/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.parameter;

import com.almworks.structure.confluence.macro.parameter.MacroParameter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class CommonMacroParameters {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(?=.{1,6}$)[0-9]+(\\.[0-9]+)?(px|%)?");

    public static MacroParameter macroSize(String name, String defaultValue) {
        return new MacroParameter(name, false, defaultValue, CommonMacroParameters::validateSize, v -> CommonMacroParameters.correctSize(v, defaultValue));
    }

    public static MacroParameter date(String name, String requiredFormat) {
        return new MacroParameter(name, false, v -> CommonMacroParameters.validateDate(v, requiredFormat));
    }

    private static String correctSize(String input, String autoValue) {
        if ("auto".equalsIgnoreCase(input = input.trim())) {
            return autoValue;
        }
        Matcher matcher = SIZE_PATTERN.matcher(input);
        if (matcher.matches()) {
            return StringUtils.isBlank((CharSequence)matcher.group(2)) ? input + "px" : input;
        }
        return autoValue;
    }

    private static boolean validateSize(String input) {
        if ("auto".equalsIgnoreCase(input = input.trim())) {
            return true;
        }
        return SIZE_PATTERN.matcher(input).matches();
    }

    private static boolean validateDate(String value, String dateFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        try {
            LocalDate.parse(value, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

