/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.AbstractMacro;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.MacroUtil;
import com.almworks.structure.confluence.macro.parameter.CommonMacroParameters;
import com.almworks.structure.confluence.macro.parameter.MacroParameter;
import com.almworks.structure.confluence.macro.rest.RestSettings;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureMacro
extends AbstractMacro {
    private static final Logger log = LoggerFactory.getLogger(StructureMacro.class);
    private static final Set<String> FILTER_TYPES = new HashSet<String>(Arrays.asList("none", "text", "jql", "sjql", "saved"));
    private final List<MacroParameter> myParameters;

    public StructureMacro(MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        super("structuremacro", appLinkClient, i18nResolver);
        MacroParameter[] macroParameterArray = new MacroParameter[13];
        macroParameterArray[0] = CommonMacroParameters.macroSize("width", "100%");
        macroParameterArray[1] = CommonMacroParameters.macroSize("height", "300px");
        macroParameterArray[2] = new MacroParameter("applink", true, v -> this.myAppLinkClient.getJiraLink((String)v) != null);
        macroParameterArray[3] = new MacroParameter("structure", true, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        macroParameterArray[4] = new MacroParameter("view", false, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        macroParameterArray[5] = new MacroParameter("filtertype", false, "none", FILTER_TYPES::contains, Function.identity());
        macroParameterArray[6] = new MacroParameter("savedfilter", false, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        macroParameterArray[7] = new MacroParameter("textfilter");
        macroParameterArray[8] = new MacroParameter("jqlfilter");
        macroParameterArray[9] = new MacroParameter("sjqlfilter");
        macroParameterArray[10] = new MacroParameter("title");
        macroParameterArray[11] = new MacroParameter("editable");
        macroParameterArray[12] = new MacroParameter("structurename");
        this.myParameters = Arrays.asList(macroParameterArray);
    }

    public String execute(Map<String, String> formParams, String s, ConversionContext conversionContext) {
        ArrayList<String> errors = new ArrayList<String>();
        Map<String, Object> parsedFormParams = this.prepareFormParams(formParams, conversionContext, errors);
        Map<String, Object> velocityParams = this.prepareVelocityParams(parsedFormParams, errors);
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/structure-macro.vm", velocityParams);
    }

    private Map<String, Object> prepareFormParams(Map<String, String> formParams, ConversionContext conversionContext, List<String> errors) {
        HashMap<String, Object> parsedFormParams = new HashMap<String, Object>();
        this.parseParameters(this.myParameters, formParams, parsedFormParams, errors);
        parsedFormParams.put("id", this.getMacroId(conversionContext));
        parsedFormParams.put("readonly", "false".equals(formParams.get("editable")));
        parsedFormParams.put("query", formParams.get(formParams.get("filtertype") + "filter"));
        return parsedFormParams;
    }

    private Map<String, Object> prepareVelocityParams(Map<String, Object> parsedFormParams, List<String> errors) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("available", errors.isEmpty());
        velocityParams.put("alttitle", this.myI18nResolver.getText("structuremacro.error.no-structure.title"));
        velocityParams.put("errors", errors);
        velocityParams.put("width", parsedFormParams.get("width"));
        velocityParams.put("height", parsedFormParams.get("height"));
        String title = (String)parsedFormParams.get("title");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            velocityParams.put("title", title);
        } else {
            velocityParams.put("title", this.getMacroTitle((String)parsedFormParams.get("structurename")));
        }
        ReadOnlyApplicationLink appLink = this.myAppLinkClient.getJiraLink((String)parsedFormParams.get("applink"));
        if (appLink != null && errors.isEmpty()) {
            if (!this.isStructureInstalled(appLink)) {
                velocityParams.put("available", false);
                errors.add(this.myI18nResolver.getText("structuremacro.error.no-structure.body"));
            } else {
                velocityParams.put("macroUrl", this.buildMacroUrl(appLink.getRpcUrl().toString(), parsedFormParams));
            }
        }
        return velocityParams;
    }

    private String buildMacroUrl(String appLinkUrl, Map<String, Object> parsedFormParams) {
        LinkedHashMap<String, Object> urlParams = new LinkedHashMap<String, Object>();
        urlParams.put("s", parsedFormParams.get("structure"));
        urlParams.put("view", parsedFormParams.get("view"));
        urlParams.put("filter", parsedFormParams.get("filtertype"));
        urlParams.put("query", parsedFormParams.get("query"));
        urlParams.put("filterid", parsedFormParams.get("savedfilter"));
        urlParams.put("readonly", parsedFormParams.get("readonly"));
        urlParams.put("gadgetid", parsedFormParams.get("id"));
        return MacroUtil.buildUrlWithParams(appLinkUrl + "/secure/StructureExternalGadget.jspa", urlParams);
    }

    private boolean isStructureInstalled(@NotNull ReadOnlyApplicationLink appLink) {
        try {
            ApplicationLinkRequestFactory factory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            Response response = this.myAppLinkClient.get(factory, "/rest/structure/2.0/macro/settings?ping=true");
            if (response.getStatusCode() == 403) {
                return true;
            }
            if (response.isSuccessful()) {
                RestSettings settings = (RestSettings)response.getEntity(RestSettings.class);
                if (Boolean.TRUE.equals(settings.structureInstalled)) {
                    return true;
                }
                if (settings.structures != null && !settings.structures.isEmpty()) {
                    return true;
                }
                if (settings.views != null && !settings.views.isEmpty()) {
                    return true;
                }
                if (settings.savedfilters != null && !settings.savedfilters.isEmpty()) {
                    return true;
                }
            }
        }
        catch (ResponseException factory) {
        }
        catch (CredentialsRequiredException | RuntimeException e) {
            log.warn("cannot check whether the structure plugin with correct version is installed", e);
        }
        return false;
    }
}

