/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.CommonSettings;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.MacroUtil;
import com.almworks.structure.confluence.macro.PopulateSettingsFunction;
import com.almworks.structure.confluence.macro.rest.RestEntity;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroSettingsLoader<T extends CommonSettings> {
    private static final Logger log = LoggerFactory.getLogger(MacroSettingsLoader.class);
    private final String myMacroKey;
    private final String mySettingsUrl;
    private final Supplier<T> myCreateSettings;
    private final PopulateSettingsFunction<T> myPopulateFromResponse;
    private final MacroAppLinkClient myAppLinkClient;
    private final I18nResolver myI18nResolver;

    public MacroSettingsLoader(String macroKey, String settingsUrl, Supplier<T> createSettings, PopulateSettingsFunction<T> populateFromResponse, MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        this.myMacroKey = macroKey;
        this.mySettingsUrl = settingsUrl;
        this.myCreateSettings = createSettings;
        this.myPopulateFromResponse = populateFromResponse;
        this.myAppLinkClient = appLinkClient;
        this.myI18nResolver = i18nResolver;
    }

    public T loadSettings(String appLinkId) {
        return this.loadSettings(appLinkId, Collections.emptyMap());
    }

    public T loadSettings(String appLinkId, Map<String, String> params) {
        List<ReadOnlyApplicationLink> links = this.myAppLinkClient.getJiraLinks();
        ReadOnlyApplicationLink link = StringUtils.isBlank((CharSequence)appLinkId) ? (ReadOnlyApplicationLink)links.stream().findFirst().orElse(null) : this.myAppLinkClient.getJiraLink(appLinkId);
        CommonSettings settings = (CommonSettings)this.myCreateSettings.get();
        settings.applinks = links.stream().map(l -> RestEntity.create(l.getId().get(), l.getName())).collect(Collectors.toList());
        if (link == null) {
            settings.error = StringUtils.isBlank((CharSequence)appLinkId) ? this.myI18nResolver.getText("macro.error.no-applinks") : this.myI18nResolver.getText("macro.error.applink-deleted", new Serializable[]{appLinkId});
            return (T)settings;
        }
        try {
            ApplicationLinkRequestFactory factory = link.createAuthenticatedRequestFactory();
            String url = !params.isEmpty() ? MacroUtil.buildUrlWithParams(this.mySettingsUrl, params) : this.mySettingsUrl;
            Response response = this.myAppLinkClient.get(factory, url);
            if (response.isSuccessful()) {
                try {
                    this.myPopulateFromResponse.populate(settings, response);
                }
                catch (ResponseException | RuntimeException e) {
                    settings.error = this.myI18nResolver.getText(this.myMacroKey + ".error.not-installed");
                }
            } else if (response.getStatusCode() == 401) {
                URI uri = link.createAuthenticatedRequestFactory().getAuthorisationURI();
                String string = settings.authurl = uri == null ? null : uri.toString();
                if (settings.authurl == null) {
                    settings.error = this.myI18nResolver.getText("macro.error.no-auth-uri");
                }
            } else {
                settings.error = response.getStatusCode() == 403 ? this.myI18nResolver.getText(this.myMacroKey + ".error.no-access") : (response.getStatusCode() == 404 ? this.myI18nResolver.getText("macro.error.no-jira-access") : (StringUtils.isBlank((CharSequence)response.getStatusText()) ? this.myI18nResolver.getText("macro.error.http.no-message", new Serializable[]{Integer.valueOf(response.getStatusCode())}) : response.getStatusText()));
            }
        }
        catch (CredentialsRequiredException e) {
            URI uri = e.getAuthorisationURI();
            settings.authurl = uri == null ? null : uri.toString();
        }
        catch (ResponseException | RuntimeException e) {
            settings.error = e.getLocalizedMessage();
            log.warn("error getting structure macro settings", e);
        }
        return (T)settings;
    }
}

