/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.util;

import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class RemoteResponse<R> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final int myStatusCode;
    private final String myStatusText;
    private final boolean mySuccessful;
    private final R myEntity;
    private final String myEntityString;
    private final IOException myDeserializationException;

    public RemoteResponse(Response response, Class<R> clazz) throws ResponseException {
        this.myStatusCode = response.getStatusCode();
        this.myStatusText = response.getStatusText();
        this.mySuccessful = response.isSuccessful();
        Object entity = null;
        String entityString = null;
        IOException deserializationException = null;
        try {
            entity = OBJECT_MAPPER.getFactory().createParser(response.getResponseBodyAsStream()).readValueAs(clazz);
        }
        catch (IOException e) {
            entityString = response.getResponseBodyAsString();
            deserializationException = e;
        }
        this.myEntity = entity;
        this.myEntityString = entityString;
        this.myDeserializationException = deserializationException;
    }

    public int getStatusCode() {
        return this.myStatusCode;
    }

    public String getStatusText() {
        return this.myStatusText;
    }

    public boolean isSuccessful() {
        return this.mySuccessful;
    }

    public R getEntity() {
        return this.myEntity;
    }

    public String getEntityString() {
        if (this.myEntityString != null) {
            return this.myEntityString;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(this.myEntity);
        }
        catch (IOException e) {
            return "<cannot stringify: " + e.getMessage() + ">";
        }
    }

    public IOException getDeserializationException() {
        return this.myDeserializationException;
    }

    public String getStatusString() {
        return this.getStatusCode() + " " + this.getStatusText();
    }

    public String toString() {
        String s = this.getStatusString() + " " + this.getEntityString();
        String exMsg = this.myDeserializationException == null ? null : this.myDeserializationException.getMessage();
        return exMsg == null ? s : s + " " + exMsg;
    }
}

