/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentBlueprintService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintPageRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructurePageService {
    private final com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService myContentBlueprintService;
    private final ContentBlueprintService myContentBlueprintServiceConfluence;
    private final ContentService myContentService;
    private final PageTemplateManager myPageTemplateManager;

    public StructurePageService(com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService contentBlueprintService, ContentBlueprintService contentBlueprintServiceConfluence, ContentService contentService, PageTemplateManager pageTemplateManager) {
        this.myContentBlueprintService = contentBlueprintService;
        this.myContentBlueprintServiceConfluence = contentBlueprintServiceConfluence;
        this.myContentService = contentService;
        this.myPageTemplateManager = pageTemplateManager;
    }

    @Nullable
    public Long createBlueprintPage(@NotNull String title, @NotNull String blueprintId, @NotNull String spaceKey, long parentPageId) throws BlueprintIllegalArgumentException {
        CreateBlueprintPageRestEntity restEntity = new CreateBlueprintPageRestEntity(spaceKey, blueprintId, "", "", "", "", parentPageId, null, new HashMap());
        ContentEntityObject draft = this.myContentBlueprintService.createContentDraft((CreateBlueprintPageEntity)restEntity, AuthenticatedUserThreadLocal.get());
        ContentId draftId = ContentId.of((ContentType)ContentType.PAGE, (long)draft.getId());
        Content draftContent = Content.builder().id(draftId).status(ContentStatus.CURRENT).build();
        Version version = Version.builder().number(1).build();
        Content publishContent = Content.builder().status(ContentStatus.CURRENT).title(title).id(draftId).type(ContentType.PAGE).space(spaceKey).version(version).body(((ContentBody.ContentBodyBuilder)((ContentBody.ContentBodyBuilder)ContentBody.contentBodyBuilder().value(draft.getBodyAsString())).representation(ContentRepresentation.STORAGE)).content(draftContent).build()).ancestors(this.buildAncestors(parentPageId)).build();
        Content content = this.myContentBlueprintServiceConfluence.publishInstance(publishContent, new Expansion[0]);
        return content.getId() == null ? null : Long.valueOf(content.getId().asLong());
    }

    @Nullable
    public Long createTemplatePage(@NotNull String title, long templateId, @NotNull String spaceKey, long parentPageId) {
        PageTemplate pageTemplate = this.myPageTemplateManager.getPageTemplate(templateId);
        Content content = Content.builder().type(ContentType.PAGE).title(title).space(spaceKey).body(((ContentBody.ContentBodyBuilder)((ContentBody.ContentBodyBuilder)ContentBody.contentBodyBuilder().value(pageTemplate.getContent())).representation(ContentRepresentation.STORAGE)).build()).ancestors(this.buildAncestors(parentPageId)).build();
        Content newPage = this.myContentService.create(content);
        return newPage.getId() == null ? null : Long.valueOf(newPage.getId().asLong());
    }

    @NotNull
    private List<Content> buildAncestors(long parentPageId) {
        return Collections.singletonList(Content.builder((ContentType)ContentType.PAGE, (long)parentPageId).build());
    }
}

