/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.RestNotificationBuilder;
import com.atlassian.confluence.pages.Page;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notification {
    private Notification() {
    }

    public abstract void addTo(RestNotificationBuilder var1);

    public static class AllSpacesChanged
    extends Notification {
        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addAllSpacesChanged();
        }

        public String toString() {
            return "AllSpacesChanged";
        }
    }

    public static class AllVisibilitiesChanged
    extends Notification {
        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addAllVisibilitiesChanged();
        }

        public String toString() {
            return "AllVisibilitiesChanged";
        }
    }

    public static class UserPermissionsChanged
    extends Notification {
        private final String myUserKey;

        public UserPermissionsChanged(@Nullable String userKey) {
            this.myUserKey = userKey;
        }

        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addUserChanged(this.myUserKey);
        }

        public String toString() {
            return "UserPermissionsChanged " + this.myUserKey;
        }
    }

    public static class SpaceVisibilityChanged
    extends Notification {
        private final String mySpaceKey;

        public SpaceVisibilityChanged(@NotNull String spaceKey) {
            this.mySpaceKey = spaceKey;
        }

        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addSpaceVisibilityChanged(this.mySpaceKey);
        }

        public String toString() {
            return "SpaceVisibilityChanged " + this.mySpaceKey;
        }
    }

    public static class SpaceChanged
    extends Notification {
        private final String mySpaceKey;

        public SpaceChanged(@NotNull String spaceKey) {
            this.mySpaceKey = spaceKey;
        }

        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addSpaceChanged(this.mySpaceKey);
        }

        public String toString() {
            return "SpaceChanged " + this.mySpaceKey;
        }
    }

    public static class PageVisibilityChanged
    extends Notification {
        private final long myPageId;

        public PageVisibilityChanged(long pageId) {
            this.myPageId = pageId;
        }

        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addPageVisibilityChanged(this.myPageId);
        }

        public String toString() {
            return "PageVisibilityChanged " + this.myPageId;
        }
    }

    public static class PageChanged
    extends Notification {
        private final long myPageId;

        public PageChanged(long pageId) {
            this.myPageId = pageId;
        }

        public PageChanged(Page page) {
            this(page.getId());
        }

        @Override
        public void addTo(RestNotificationBuilder builder) {
            builder.addPageChanged(this.myPageId);
        }

        public String toString() {
            return "PageChanged " + this.myPageId;
        }
    }
}

