/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.Notification;
import com.almworks.structure.confluence.helper.NotificationTracker;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.admin.GlobalPermissionsUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpacePermissionsUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceUnArchivedEvent;
import com.atlassian.confluence.event.events.template.TemplateEvent;
import com.atlassian.confluence.event.events.template.TemplateRemoveEvent;
import com.atlassian.confluence.event.events.template.TemplateUpdateEvent;
import com.atlassian.confluence.event.events.types.Created;
import com.atlassian.confluence.event.events.types.Removed;
import com.atlassian.confluence.event.events.types.Updated;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth.event.TokenRemovedEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EventNotificationBridge
implements DisposableBean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(EventNotificationBridge.class);
    private final EventPublisher myEventPublisher;
    private final NotificationTracker myNotificationTracker;

    public EventNotificationBridge(EventPublisher eventPublisher, NotificationTracker notificationTracker) {
        this.myEventPublisher = eventPublisher;
        this.myNotificationTracker = notificationTracker;
        eventPublisher.register((Object)this);
    }

    public String toString() {
        return "Event-notification bridge";
    }

    public void afterPropertiesSet() throws Exception {
        this.myNotificationTracker.record(new Notification.AllVisibilitiesChanged());
    }

    public void destroy() throws Exception {
        logger.warn(this + " stopping");
        this.myEventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSpaceEvent(SpaceEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug(e.getClass().getSimpleName() + " " + e.getSpace().getKey());
        }
        if (e instanceof Updated) {
            this.myNotificationTracker.record(new Notification.SpaceChanged(e.getSpace().getKey()));
        }
        if (e instanceof SpacePermissionsUpdateEvent || e instanceof Removed || e instanceof Created || e instanceof SpaceArchivedEvent || e instanceof SpaceUnArchivedEvent) {
            this.myNotificationTracker.record(new Notification.SpaceVisibilityChanged(e.getSpace().getKey()));
        }
    }

    @EventListener
    public void onTemplateEvent(TemplateEvent e) {
        PageTemplate template = null;
        if (e instanceof TemplateRemoveEvent) {
            template = ((TemplateRemoveEvent)e).getTemplate();
        } else if (e instanceof TemplateUpdateEvent && (template = ((TemplateUpdateEvent)e).getNewTemplate()) == null) {
            template = ((TemplateUpdateEvent)e).getOldTemplate();
        }
        if (template != null && template.getSpace() != null) {
            this.myNotificationTracker.record(new Notification.SpaceChanged(template.getSpace().getKey()));
        } else if (template != null && template.getSpace() == null) {
            this.myNotificationTracker.record(new Notification.AllSpacesChanged());
        }
    }

    @EventListener
    public void onPageEvent(PageEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug(e.getClass().getSimpleName() + " " + e.getPage().getId());
        }
        if (e instanceof Created) {
            this.onPageCreated(e);
        } else if (e instanceof PageMoveEvent) {
            this.onPageMoved((PageMoveEvent)e);
        } else if (e instanceof Updated) {
            this.onPageUpdated(e);
        } else if (e instanceof PageTrashedEvent || e instanceof PageRestoreEvent) {
            this.myNotificationTracker.record(new Notification.PageVisibilityChanged(e.getPage().getId()));
        }
    }

    private void onPageCreated(PageEvent e) {
        Page page = e.getPage();
        this.myNotificationTracker.record(new Notification.PageChanged(page));
        this.recordPageParentChange(page.getParent(), page.getSpace());
    }

    private void onPageMoved(PageMoveEvent e) {
        Page page = e.getPage();
        Page newParent = e.getNewParentPage();
        Space newSpace = page.getSpace();
        Page oldParent = e.getOldParentPage();
        Space oldSpace = e.getOldSpace();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("PageMoveEvent %d (%s, %s) -> (%s, %s)", page.getId(), EventNotificationBridge.idStr((EntityObject)newParent), EventNotificationBridge.idStr((EntityObject)newSpace), EventNotificationBridge.idStr((EntityObject)oldParent), EventNotificationBridge.idStr((EntityObject)oldSpace)));
        }
        this.recordPageParentChange(newParent, newSpace);
        if (oldParent != newParent || newParent == null && oldSpace != newSpace) {
            this.recordPageParentChange(oldParent, oldSpace);
        }
        this.myNotificationTracker.record(new Notification.PageChanged(page));
    }

    private void onPageUpdated(PageEvent e) {
        this.myNotificationTracker.record(new Notification.PageChanged(e.getPage()));
    }

    private void recordPageParentChange(@Nullable Page parent, @Nullable Space space) {
        if (parent != null) {
            this.myNotificationTracker.record(new Notification.PageChanged(parent));
        } else if (space != null) {
            this.myNotificationTracker.record(new Notification.SpaceChanged(space.getKey()));
        }
    }

    @EventListener
    public void onPagePermissionChange(ContentPermissionEvent e) {
        ContentEntityObject content = e.getContent();
        if (logger.isDebugEnabled()) {
            logger.debug("ContentPermissionEvent " + content.getClass().getSimpleName() + " " + content.getId());
        }
        if (content instanceof Page) {
            this.myNotificationTracker.record(new Notification.PageVisibilityChanged(content.getId()));
        }
    }

    @EventListener
    public void onTokenRemoved(TokenRemovedEvent e) {
        logger.debug("TokenRemoved");
        this.myNotificationTracker.record(new Notification.UserPermissionsChanged(e.getUsername()));
    }

    @EventListener
    public void onGroupMembershipCreated(GroupMembershipCreatedEvent e) {
        logger.debug("GroupMembershipCreated");
        String entityName = e.getEntityName();
        if (e.getMembershipType() == MembershipType.GROUP_USER) {
            this.myNotificationTracker.record(new Notification.UserPermissionsChanged(entityName));
        } else if (e.getMembershipType() == MembershipType.GROUP_GROUP) {
            this.myNotificationTracker.record(new Notification.AllVisibilitiesChanged());
        }
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent e) {
        logger.debug("GroupMembershipDeleted");
        String entityName = e.getEntityName();
        if (e.getMembershipType() == MembershipType.GROUP_USER) {
            this.myNotificationTracker.record(new Notification.UserPermissionsChanged(entityName));
        } else if (e.getMembershipType() == MembershipType.GROUP_GROUP) {
            this.myNotificationTracker.record(new Notification.AllVisibilitiesChanged());
        }
    }

    @EventListener
    public void onDirectoryEvent(DirectoryEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug(e.getClass().getSimpleName());
        }
        if (e instanceof GroupCreatedEvent || e instanceof GroupUpdatedEvent || e instanceof GroupDeletedEvent) {
            this.myNotificationTracker.record(new Notification.AllVisibilitiesChanged());
        }
    }

    @EventListener
    public void onGlobalPermissionsUpdated(GlobalPermissionsUpdateEvent e) {
        logger.debug("GlobalPermissionsUpdate");
        this.myNotificationTracker.record(new Notification.AllVisibilitiesChanged());
    }

    @EventListener
    public void onLabelEvent(LabelEvent e) {
        long pageId = EventNotificationBridge.getPageId(e.getLabelled());
        if (logger.isDebugEnabled()) {
            logger.debug(e.getClass().getSimpleName() + " " + e.getLabelled().getClass().getSimpleName() + " " + pageId);
        }
        if (pageId != 0L && (e instanceof LabelAddEvent || e instanceof LabelRemoveEvent)) {
            this.myNotificationTracker.record(new Notification.PageChanged(pageId));
        }
    }

    private static long getPageId(Object o) {
        if (o instanceof Page) {
            return ((Page)o).getId();
        }
        return 0L;
    }

    private static String idStr(@Nullable EntityObject o) {
        return o == null ? "null" : String.valueOf(o.getId());
    }
}

