/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.gantt.macro;

import com.almworks.structure.confluence.macro.AbstractMacro;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.StructureMacroParameter;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GanttMacro
extends AbstractMacro {
    private final List<StructureMacroParameter> myParameters = Arrays.asList(new StructureMacroParameter("width", false, "100%", x$0 -> AbstractMacro.validateSize(x$0), v -> GanttMacro.correctSize(v, "100%")), new StructureMacroParameter("height", false, "300px", x$0 -> AbstractMacro.validateSize(x$0), v -> GanttMacro.correctSize(v, "300px")), new StructureMacroParameter("applink", true, v -> this.myAppLinkClient.getJiraLink((String)v) != null), new StructureMacroParameter("structure", true, v -> LONG_PATTERN.matcher((CharSequence)v).matches()), new StructureMacroParameter("structurename"));

    public GanttMacro(MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        super("ganttmacro", appLinkClient, i18nResolver);
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) {
        HashMap<String, Object> velocityParameters = new HashMap<String, Object>();
        ArrayList<String> errors = new ArrayList<String>();
        this.parseParameters(this.myParameters, map, velocityParameters, errors);
        if (!errors.isEmpty()) {
            return (String)errors.get(0);
        }
        ReadOnlyApplicationLink appLink = this.myAppLinkClient.getJiraLink(map.get("applink"));
        if (appLink != null) {
            velocityParameters.put("link", appLink.getRpcUrl());
        }
        velocityParameters.put("title", this.getMacroTitle(map.get("structurename")));
        velocityParameters.put("id", this.getMacroId(conversionContext));
        return VelocityUtils.getRenderedTemplate((String)"templates/gantt/macro/gantt-macro.vm", velocityParameters);
    }
}

