/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.web;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.web.RestEntity;
import com.almworks.structure.confluence.macro.web.RestSettings;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/macro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class MacroResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(MacroResource.class);
    private final MacroAppLinkClient myAppLinkClient;
    protected final I18nResolver myI18nResolver;

    @Inject
    public MacroResource(MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        this.myAppLinkClient = appLinkClient;
        this.myI18nResolver = i18nResolver;
    }

    @GET
    @Path(value="/settings")
    public Response settings(@QueryParam(value="link") String appLinkId) {
        List<ReadOnlyApplicationLink> links = this.myAppLinkClient.getJiraLinks();
        ReadOnlyApplicationLink link = StringUtils.isBlank((CharSequence)appLinkId) ? (ReadOnlyApplicationLink)links.stream().findFirst().orElse(null) : this.myAppLinkClient.getJiraLink(appLinkId);
        RestSettings settings = new RestSettings();
        settings.applinks = links.stream().map(l -> RestEntity.create(l.getId().get(), l.getName())).collect(Collectors.toList());
        if (link == null) {
            settings.error = StringUtils.isBlank((CharSequence)appLinkId) ? this.myI18nResolver.getText("structuremacro.error.no-applinks") : this.myI18nResolver.getText("structuremacro.error.applink-deleted", new Serializable[]{appLinkId});
            return MacroResource.ok(settings);
        }
        try {
            ApplicationLinkRequestFactory factory = link.createAuthenticatedRequestFactory();
            com.atlassian.sal.api.net.Response response = this.myAppLinkClient.get(factory, "/rest/structure/2.0/macro/settings");
            if (response.isSuccessful()) {
                try {
                    RestSettings jiraData = (RestSettings)response.getEntity(RestSettings.class);
                    settings.structures = jiraData.structures;
                    settings.views = jiraData.views;
                    settings.savedfilters = jiraData.savedfilters;
                    settings.error = jiraData.error;
                }
                catch (ResponseException | RuntimeException e) {
                    settings.error = this.myI18nResolver.getText("structuremacro.error.no-structure-installed");
                }
            } else if (response.getStatusCode() == 401) {
                URI uri = link.createAuthenticatedRequestFactory().getAuthorisationURI();
                String string = settings.authurl = uri == null ? null : uri.toString();
                if (settings.authurl == null) {
                    settings.error = this.myI18nResolver.getText("structuremacro.error.no-auth-uri");
                }
            } else {
                settings.error = response.getStatusCode() == 403 ? this.myI18nResolver.getText("structuremacro.error.no-structure-access") : (response.getStatusCode() == 404 ? this.myI18nResolver.getText("structuremacro.error.no-jira-access") : (StringUtils.isBlank((CharSequence)response.getStatusText()) ? this.myI18nResolver.getText("structuremacro.error.http.no-message", new Serializable[]{Integer.valueOf(response.getStatusCode())}) : response.getStatusText()));
            }
        }
        catch (CredentialsRequiredException e) {
            URI uri = e.getAuthorisationURI();
            settings.authurl = uri == null ? null : uri.toString();
        }
        catch (ResponseException | RuntimeException e) {
            settings.error = e.getLocalizedMessage();
            log.warn("error getting structure macro settings", e);
        }
        return MacroResource.ok(settings);
    }
}

