/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.AbstractMacro;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.StructureMacroParameter;
import com.almworks.structure.confluence.macro.web.RestSettings;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureMacro
extends AbstractMacro {
    private static final Logger log = LoggerFactory.getLogger(StructureMacro.class);
    private static final Set<String> FILTER_TYPES = new HashSet<String>(Arrays.asList("none", "text", "jql", "sjql", "saved"));
    private final List<StructureMacroParameter> myParameters;

    public StructureMacro(MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        super("structuremacro", appLinkClient, i18nResolver);
        StructureMacroParameter[] structureMacroParameterArray = new StructureMacroParameter[13];
        structureMacroParameterArray[0] = new StructureMacroParameter("width", false, "100%", AbstractMacro::validateSize, v -> StructureMacro.correctSize(v, "100%"));
        structureMacroParameterArray[1] = new StructureMacroParameter("height", false, "300px", AbstractMacro::validateSize, v -> StructureMacro.correctSize(v, "300px"));
        structureMacroParameterArray[2] = new StructureMacroParameter("applink", true, v -> this.myAppLinkClient.getJiraLink((String)v) != null);
        structureMacroParameterArray[3] = new StructureMacroParameter("structure", true, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        structureMacroParameterArray[4] = new StructureMacroParameter("view", false, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        structureMacroParameterArray[5] = new StructureMacroParameter("filtertype", false, "none", FILTER_TYPES::contains, Function.identity());
        structureMacroParameterArray[6] = new StructureMacroParameter("savedfilter", false, v -> LONG_PATTERN.matcher((CharSequence)v).matches());
        structureMacroParameterArray[7] = new StructureMacroParameter("textfilter");
        structureMacroParameterArray[8] = new StructureMacroParameter("jqlfilter");
        structureMacroParameterArray[9] = new StructureMacroParameter("sjqlfilter");
        structureMacroParameterArray[10] = new StructureMacroParameter("title");
        structureMacroParameterArray[11] = new StructureMacroParameter("editable");
        structureMacroParameterArray[12] = new StructureMacroParameter("structurename");
        this.myParameters = Arrays.asList(structureMacroParameterArray);
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) {
        HashMap<String, Object> velocityParameters = new HashMap<String, Object>();
        ArrayList<String> errors = new ArrayList<String>();
        this.parseParameters(this.myParameters, map, velocityParameters, errors);
        velocityParameters.put("available", errors.isEmpty());
        velocityParameters.put("alttitle", this.myI18nResolver.getText("structuremacro.error.no-structure.title"));
        velocityParameters.put("errors", errors);
        ReadOnlyApplicationLink appLink = this.myAppLinkClient.getJiraLink(map.get("applink"));
        if (appLink != null && errors.isEmpty()) {
            velocityParameters.put("link", appLink.getRpcUrl());
            boolean available = this.isStructureInstalled(appLink);
            velocityParameters.put("available", available);
            if (!available) {
                errors.add(this.myI18nResolver.getText("structuremacro.error.no-structure.body"));
            }
        }
        if (StringUtils.isBlank((CharSequence)map.get("title"))) {
            velocityParameters.put("title", this.getMacroTitle(map.get("structurename")));
        }
        velocityParameters.put("id", this.getMacroId(conversionContext));
        velocityParameters.put("readonly", "false".equals(map.get("editable")));
        velocityParameters.put("query", map.get(map.get("filtertype") + "filter"));
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/macro.vm", velocityParameters);
    }

    private boolean isStructureInstalled(@NotNull ReadOnlyApplicationLink appLink) {
        try {
            ApplicationLinkRequestFactory factory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            Response response = this.myAppLinkClient.get(factory, "/rest/structure/2.0/macro/settings?ping=true");
            if (response.getStatusCode() == 403) {
                return true;
            }
            if (response.isSuccessful()) {
                RestSettings settings = (RestSettings)response.getEntity(RestSettings.class);
                if (Boolean.TRUE.equals(settings.structureInstalled)) {
                    return true;
                }
                if (settings.structures != null && !settings.structures.isEmpty()) {
                    return true;
                }
                if (settings.views != null && !settings.views.isEmpty()) {
                    return true;
                }
                if (settings.savedfilters != null && !settings.savedfilters.isEmpty()) {
                    return true;
                }
            }
        }
        catch (ResponseException factory) {
        }
        catch (CredentialsRequiredException | RuntimeException e) {
            log.warn("cannot check whether the structure plugin with correct version is installed", e);
        }
        return false;
    }
}

