/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.StructureMacroParameter;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMacro
implements Macro {
    protected static final Pattern LONG_PATTERN = Pattern.compile("[0-9]+");
    protected static final Pattern SIZE_PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+)?(px|%)?");
    protected final MacroAppLinkClient myAppLinkClient;
    protected final I18nResolver myI18nResolver;
    protected final String myMacroName;

    protected AbstractMacro(String macroName, MacroAppLinkClient appLinkClient, I18nResolver i18nResolver) {
        this.myMacroName = macroName;
        this.myAppLinkClient = appLinkClient;
        this.myI18nResolver = i18nResolver;
    }

    protected static String correctSize(String input, String autoValue) {
        if ("auto".equalsIgnoreCase(input = input.trim())) {
            return autoValue;
        }
        Matcher matcher = SIZE_PATTERN.matcher(input);
        if (matcher.matches()) {
            return StringUtils.isBlank((CharSequence)matcher.group(2)) ? input + "px" : input;
        }
        return autoValue;
    }

    protected static boolean validateSize(String input) {
        if ("auto".equalsIgnoreCase(input = input.trim())) {
            return true;
        }
        return SIZE_PATTERN.matcher(input).matches();
    }

    protected String getMacroId(ConversionContext conversionContext) {
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        return macroDefinition.getMacroIdentifier().map(MacroId::getId).orElse(null);
    }

    protected String getMacroTitle(String objectName) {
        String i18nKey = StringUtils.isBlank((CharSequence)objectName) ? "title.default" : "title";
        return this.myI18nResolver.getText(this.myMacroName + "." + i18nKey, new Serializable[]{objectName});
    }

    protected void parseParameters(List<StructureMacroParameter> parameters, Map<String, String> map, Map<String, Object> velocityParameters, List<String> errors) {
        for (StructureMacroParameter param : parameters) {
            String value;
            if (param.isValid(value = map.getOrDefault(param.getName(), param.getDefaultValue()))) {
                velocityParameters.put(param.getName(), param.correct(value));
                continue;
            }
            velocityParameters.put(param.getName(), param.getDefaultValue());
            errors.add(this.myI18nResolver.getText("structuremacro.error.invalid-parameter", new Serializable[]{param.getName(), value}));
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

