/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import java.util.function.Function;
import java.util.function.Predicate;

public class StructureMacroParameter {
    private final String myName;
    private final boolean myRequired;
    private final String myDefaultValue;
    private final Predicate<String> myValidation;
    private final Function<String, String> myCorrection;

    public StructureMacroParameter(String name, String defaultValue, Predicate<String> validation, Function<String, String> correction) {
        this.myName = name;
        this.myRequired = defaultValue == null;
        this.myDefaultValue = defaultValue;
        this.myValidation = validation;
        this.myCorrection = correction;
    }

    public boolean isValid(String value) {
        if (value == null) {
            return !this.myRequired;
        }
        return this.myValidation.test(value);
    }

    public String correct(String value) {
        return this.myCorrection.apply(value);
    }

    public String getName() {
        return this.myName;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }
}

