/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro;

import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.StructureMacroParameter;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StructureMacro
implements Macro {
    private static final Pattern LONG_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern SIZE_PATTERN = Pattern.compile("\\*|([0-9]*(\\.[0-9]+)?)([a-zA-Z%-]*)");
    private static final Function<String, String> SIZE_CORRECTION = value -> {
        Matcher m = SIZE_PATTERN.matcher((CharSequence)value);
        if (m.matches() && !StringUtils.isBlank((CharSequence)m.group(1)) && StringUtils.isBlank((CharSequence)m.group(3))) {
            return m.group(1) + "px";
        }
        return value;
    };
    private final MacroAppLinkClient myAppLinkClient;
    private final List<StructureMacroParameter> parameters;

    public StructureMacro(MacroAppLinkClient appLinkClient) {
        this.myAppLinkClient = appLinkClient;
        this.parameters = Arrays.asList(new StructureMacroParameter("width", "100%", v -> SIZE_PATTERN.matcher((CharSequence)v).matches(), SIZE_CORRECTION), new StructureMacroParameter("height", "300px", v -> SIZE_PATTERN.matcher((CharSequence)v).matches(), SIZE_CORRECTION), new StructureMacroParameter("applink", null, v -> this.myAppLinkClient.getJiraLink((String)v) != null, Function.identity()), new StructureMacroParameter("structure", null, v -> LONG_PATTERN.matcher((CharSequence)v).matches(), Function.identity()), new StructureMacroParameter("view", null, v -> LONG_PATTERN.matcher((CharSequence)v).matches(), Function.identity()));
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        HashMap<String, String> velocityParameters = new HashMap<String, String>();
        for (StructureMacroParameter param : this.parameters) {
            String value;
            if (param.isValid(value = map.getOrDefault(param.getName(), param.getDefaultValue()))) {
                velocityParameters.put(param.getName(), param.correct(value));
                continue;
            }
            return "Value for parameter " + param.getName() + " is invalid: " + TextUtils.htmlEncode((String)value);
        }
        velocityParameters.put("link", (String)this.myAppLinkClient.getJiraLink(map.get("applink")));
        return VelocityUtils.getRenderedTemplate((String)"templates/macro/macro.vm", velocityParameters);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

