require(['jquery', 'wrm/context-path'], function ($, contextPathFunc) {
  $(document).ready(function () {
    const mb = window.parent.AJS.MacroBrowser;
    const fields = {};
    const contextPath = contextPathFunc() || '';
    const requested = {};
    const handleVisibilityChange = () => {
      if (!document.hidden) getData(fields.applink?.getValue());
    };

    function encodeHTML(text) {
      return text.replace(/[\u00A0-\u9999<>&]/g, i => '&#' + i.charCodeAt(0) + ';');
    }

    function updatePreview() {
      mb.previewMacro(mb.dialog.activeMetadata);
    }

    function setupField(name, setup) {
      return function (param, options) {
        const field = mb.ParameterFields['enum'](param, options);
        fields[name] = field;
        setup?.(field);
        field.input.on('change', () => updatePreview());
        return field;
      };
    }

    function adjustAppLinksSelector(data) {
      const paramDiv$ = fields.applink?.input?.closest('.macro-param-div');
      if (!paramDiv$) return;
      const link$ = paramDiv$.find('.ch-macro-link');
      const error$ = paramDiv$.find('.ch-macro-error');

      link$.toggle(!!data?.authurl);
      link$.attr('href', data?.authurl || '#');
      error$.toggle(!!data?.error);
      error$.html(encodeHTML(data?.error || ''));

      document.removeEventListener('visibilitychange', handleVisibilityChange);
      if (data?.authurl) {
        document.addEventListener('visibilitychange', handleVisibilityChange);
      }
    }

    function getData(appLink, restoredValues) {
      if ((requested.link === appLink) && appLink) return;
      requested.link = appLink;
      let url = '/rest/structure-helper/1.0/macro/settings';
      if (appLink) {
        url = url + '?link=' + encodeURIComponent(appLink);
      }

      function assignOptions(field, options, restoredValue) {
        const html = options?.map(o => `
                        <option value="${encodeHTML(o.key)}">
                            ${encodeHTML(o.value)}
                        </option>
                    `)?.join('');
        field?.input?.html(html || '');
        field?.input?.prop("disabled", !options);
        if (restoredValue) {
          field.input.val(restoredValue);
        }
        field.setValue(field.input.val());
      }

      function callback(data) {
        if (requested.link !== appLink) return;
        assignOptions(fields.applink, data?.applinks, restoredValues?.applink);
        assignOptions(fields.structure, data?.structures, restoredValues?.structure);
        assignOptions(fields.view, data?.views, restoredValues?.view);
        adjustAppLinksSelector(data);
        updatePreview();
        delete requested.link;
      }

      fetch(contextPath + url)
        .then(r => r.json())
        .then(r => callback(r))
        .catch(error => console.log(error));
    }

    mb.setMacroJsOverride('structuremacro', {
      fields: {
        enum: {
          structure: setupField('structure'),
          view: setupField('view'),
          applink: setupField('applink', field => {
            getData(field.getValue(), mb.settings?.selectedMacro?.params);
            field.input.on('change', () => getData(field.input.val()));

            field.input.closest('.macro-param-div').append(`
              <div class="ch-macro-error"></div>
              <a class="ch-macro-link" href="#" target="_blank">Authenticate</a>
            `);
            adjustAppLinksSelector();
          })
        }
      }
    });
  });
});