/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.macro.web;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.almworks.structure.confluence.macro.MacroAppLinkClient;
import com.almworks.structure.confluence.macro.web.RestEntity;
import com.almworks.structure.confluence.macro.web.RestSettings;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/macro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@AnonymousSiteAccess
public class MacroResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(MacroResource.class);
    private final MacroAppLinkClient myAppLinkClient;

    @Inject
    public MacroResource(MacroAppLinkClient myAppLinkClient) {
        this.myAppLinkClient = myAppLinkClient;
    }

    @GET
    @Path(value="/settings")
    public Response settings(@QueryParam(value="link") String appLinkId) {
        ReadOnlyApplicationLink link = this.myAppLinkClient.getJiraLink(appLinkId);
        List<ReadOnlyApplicationLink> links = this.myAppLinkClient.getJiraLinks();
        if (link == null) {
            link = links.stream().findFirst().orElse(null);
        }
        RestSettings settings = new RestSettings();
        settings.applinks = links.stream().map(l -> RestEntity.create(l.getId().get(), l.getName())).collect(Collectors.toList());
        try {
            com.atlassian.sal.api.net.Response response = this.myAppLinkClient.get(link, "/rest/structure/2.0/macro/settings");
            if (response.getStatusCode() < 300) {
                try {
                    RestSettings jiraData = (RestSettings)response.getEntity(RestSettings.class);
                    settings.structures = jiraData.structures;
                    settings.views = jiraData.views;
                }
                catch (ResponseException | RuntimeException e) {
                    settings.error = "Cannot get settings from structure on " + Objects.requireNonNull(link).getName();
                }
            } else {
                settings.error = StringUtils.isBlank((CharSequence)response.getStatusText()) ? "Error " + response.getStatusCode() : response.getStatusText();
            }
        }
        catch (CredentialsRequiredException e) {
            URI uri = e.getAuthorisationURI();
            settings.authurl = uri == null ? null : uri.toString();
        }
        catch (ResponseException | RuntimeException e) {
            settings.error = e.getLocalizedMessage();
            log.warn("error getting structure macro settings", e);
        }
        return MacroResource.ok(settings);
    }
}

