/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class OneElementQueue<E>
extends AbstractCollection<E>
implements BlockingQueue<E> {
    private final Supplier<E> mySupplier;

    public OneElementQueue(Supplier<E> supplier) {
        this.mySupplier = supplier;
    }

    protected E generate() {
        return this.mySupplier.get();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            boolean used;

            @Override
            public boolean hasNext() {
                return !this.used;
            }

            @Override
            public E next() {
                if (this.used) {
                    throw new NoSuchElementException();
                }
                this.used = true;
                return OneElementQueue.this.generate();
            }

            @Override
            public void remove() {
                if (!this.used) {
                    throw new IllegalStateException();
                }
            }
        };
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public E remove() {
        return this.generate();
    }

    @Override
    public E poll() {
        return this.generate();
    }

    @Override
    public E element() {
        return this.generate();
    }

    @Override
    public E peek() {
        return this.generate();
    }

    @Override
    public void put(E e) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public E take() throws InterruptedException {
        return this.generate();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.generate();
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        c.add(this.generate());
        return 1;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return this.drainTo(c);
    }
}

