require(['jquery'], function ($) {
  /*
     The below script is needed for gadget macro preview only when accessed via a structure-page item.
     Is used for instance to avoid security errors when trying to access a cross origin top window
    */
  $(document).ready(function () {
    const enabled = window.parent && window.parent.name === 'structure-confluence-page';
    if (!enabled) return;

    if (!isTopAccessible()) {
      tryAdaptGadgetMacroPreviewInitialization();
    }

    function tryAdaptGadgetMacroPreviewInitialization() {
      try {
        /*
         copied and adapted from 'com.atlassian.confluence.plugins.gadgets:gadget-render-resources'
         location ='script/macroFieldsConfig/gadgetPreview.js'

         replaced window.top with window.parent, otherwise browser can block script execution due to security reasons
         (iframes in one origin trying to access content from top window in another distinct origin)
         */
        const mb = window.parent.AJS.MacroBrowser;
        if (mb) {
          log("[structure-confluence-macro-browser-adapter] Macro browser is present. So we're in a preview iframe from macro browser.");

          mb.gadgetPrefs = {};
          mb.gadgetPrefsChanged = false;

          mb.Macros.gadget.manipulateMarkup = function () {
            if(mb.gadgetPrefsChanged){
              var container = window.parent.document.getElementById("macro-insert-container");
              var preferencesInput = $("#macro-param-div-preferences input", container);
              var baseVal = "";
              for (var key in mb.gadgetPrefs)
              {
                if (baseVal.length != 0)
                {
                  baseVal += "&";
                }
                baseVal = baseVal + encodeURI(key) + "=" + encodeURI(mb.gadgetPrefs[key]);
              }
              preferencesInput.val(baseVal);
            }
          };

          gadgets.IfrGadgetService.prototype.setUserPref = function(editToken, name, value)
          {
            mb.gadgetPrefs[name] = value;
            mb.gadgetPrefsChanged = true;
            if(name == "isConfigured") {
              var warningSpan = window.parent.AJS.$("#save-warning-span");
              if(warningSpan[0]) {
                warningSpan.removeClass("gadget-not-configured-warning").addClass("hidden");
                var okButton = window.parent.AJS.$("#macro-browser-dialog .dialog-button-panel .ok");
                okButton.prop("disabled", false);
              }
            }

            mb.Macros["gadget"].manipulateMarkup();
          };
        } else {
          log("[structure-confluence-macro-browser-adapter] Not running within macro browser.");
        }
      } catch (e) {
        log('[structure-confluence-macro-browser-adapter] gadget macro initialization failed', e);
      }
    }

    function log(msg, e) {
      try {
        if (console && console.log) {
          if (e) msg += ' ' + e + ' ' + e.stack;
          console.log(msg);
        }
      } catch (ignored) {}
    }

    function isTopAccessible() {
      try {
        window.top.AJS;
        return true;
      } catch (err) {
        return false;
      }
    }
  });

});