/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.security;

import com.almworks.structure.confluence.helper.security.SecurityInterceptorEnhancer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSiteCookieAttributeFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(SameSiteCookieAttributeFilter.class);

    public void init(@NotNull FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ("https".equalsIgnoreCase(request.getScheme()) && response instanceof HttpServletResponse && request instanceof HttpServletRequest && SecurityInterceptorEnhancer.hasOurCookie((HttpServletRequest)request)) {
            chain.doFilter(request, (ServletResponse)new SameSiteResponseProxy((HttpServletRequest)request, (HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    private class SameSiteResponseProxy
    extends HttpServletResponseWrapper {
        @NotNull
        private final HttpServletResponse myResponse;
        @NotNull
        private final HttpServletRequest myRequest;

        public SameSiteResponseProxy(@NotNull HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.myResponse = response;
            this.myRequest = request;
        }

        public void sendRedirect(String location) throws IOException {
            SameSiteCookieAttributeFilter.this.logger.debug("sendRedirect(String) called");
            SecurityInterceptorEnhancer.appendSameSite(this.myRequest, this.myResponse);
            super.sendRedirect(location);
        }
    }
}

