/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import com.almworks.integers.LongSetBuilder;
import com.almworks.structure.confluence.helper.rest.RestNotification;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestNotificationBuilder {
    private final LongSetBuilder myPagesChanged;
    private final LongSetBuilder myPagesVisibilityChanged;
    private ImmutableSet.Builder<String> mySpacesVisibilityChanged;
    private ImmutableSet.Builder<String> myUsersChanged;
    private ImmutableSet.Builder<String> mySpacesChanged;
    private boolean myIsAllVisibilitiesChanged;
    private boolean myIsAllSpacesChanged;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public RestNotificationBuilder(int nNotifications) {
        this.myPagesChanged = RestNotificationBuilder.longSetBuilder(nNotifications);
        this.myPagesVisibilityChanged = RestNotificationBuilder.longSetBuilder(nNotifications);
        this.mySpacesChanged = ImmutableSet.builder();
        this.mySpacesVisibilityChanged = ImmutableSet.builder();
        this.myUsersChanged = ImmutableSet.builder();
        this.myIsAllVisibilitiesChanged = false;
        this.myIsAllSpacesChanged = false;
    }

    private static LongSetBuilder longSetBuilder(int sizeUpperEstimate) {
        return sizeUpperEstimate < 16 ? new LongSetBuilder(16) : new LongSetBuilder();
    }

    public void addPageChanged(long pageId) {
        this.myPagesChanged.add(pageId);
    }

    public void addPageVisibilityChanged(long pageId) {
        this.myPagesVisibilityChanged.add(pageId);
    }

    public void addSpaceChanged(@NotNull String spaceKey) {
        this.mySpacesChanged.add((Object)spaceKey);
    }

    public void addSpaceVisibilityChanged(@NotNull String spaceKey) {
        this.mySpacesVisibilityChanged.add((Object)spaceKey);
    }

    public void addUserChanged(@Nullable String userKey) {
        this.myUsersChanged.add((Object)(userKey == null ? "" : userKey));
    }

    public void addAllVisibilitiesChanged() {
        this.myIsAllVisibilitiesChanged = true;
    }

    public void addAllSpacesChanged() {
        this.myIsAllSpacesChanged = true;
    }

    public RestNotification build() {
        RestNotification dest = new RestNotification();
        dest.pagesChanged = RestNotificationBuilder.toArray(this.myPagesChanged);
        dest.pagesVisibilityChanged = RestNotificationBuilder.toArray(this.myPagesVisibilityChanged);
        dest.spacesChanged = RestNotificationBuilder.toArray(this.mySpacesChanged);
        dest.spacesVisibilityChanged = RestNotificationBuilder.toArray(this.mySpacesVisibilityChanged);
        dest.usersChanged = RestNotificationBuilder.toArray(this.myUsersChanged);
        dest.isAllVisibilitiesChanged = this.myIsAllVisibilitiesChanged;
        dest.isAllSpacesChanged = this.myIsAllSpacesChanged;
        return dest;
    }

    @Nullable
    private static long[] toArray(LongSetBuilder builder) {
        return builder.isEmpty() ? null : builder.commitToArray().toNativeArray();
    }

    private static String[] toArray(ImmutableSet.Builder<String> builder) {
        ImmutableSet set = builder.build();
        return set.isEmpty() ? null : (String[])set.toArray((Object[])new String[set.size()]);
    }

    public RestNotificationBuilder mergeValues(RestNotification src) {
        this.myPagesChanged.mergeFromSortedCollection((LongList)new LongArray(src.pagesChanged));
        this.myPagesVisibilityChanged.mergeFromSortedCollection((LongList)new LongArray(src.pagesChanged));
        this.mySpacesChanged = ImmutableSet.builder().addAll((Iterable)this.mySpacesChanged.build()).add((Object[])RestNotificationBuilder.nnarr(src.spacesChanged));
        this.mySpacesVisibilityChanged = ImmutableSet.builder().addAll((Iterable)this.mySpacesVisibilityChanged.build()).add((Object[])RestNotificationBuilder.nnarr(src.spacesVisibilityChanged));
        this.myUsersChanged = ImmutableSet.builder().addAll((Iterable)this.myUsersChanged.build()).add((Object[])RestNotificationBuilder.nnarr(src.usersChanged));
        this.myIsAllVisibilitiesChanged |= src.isAllVisibilitiesChanged;
        this.myIsAllSpacesChanged |= src.isAllSpacesChanged;
        return this;
    }

    private static String[] nnarr(String[] arr) {
        return arr == null ? EMPTY_STRING_ARRAY : arr;
    }
}

