/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.AppLinkClient;
import com.almworks.structure.confluence.helper.Notification;
import com.almworks.structure.confluence.helper.RestNotificationBuilder;
import com.almworks.structure.confluence.helper.Subscription;
import com.almworks.structure.confluence.helper.rest.RestNotification;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NotificationSender {
    public static final SuccessHandler SUCCESS_HANDLER = new SuccessHandler();
    private static final Logger log = LoggerFactory.getLogger(NotificationSender.class);
    private ObjectMapper myObjectMapper;
    private final ReadOnlyApplicationLinkService myAppLinkService;
    private Map<Subscription, List<Notification>> myPendingNotifications = Collections.emptyMap();

    public NotificationSender(ReadOnlyApplicationLinkService appLinkService) {
        this.myAppLinkService = appLinkService;
    }

    public boolean hasPendingNotifications(Collection<Subscription> subscriptions) {
        return Iterables.any(this.myPendingNotifications.keySet(), (Predicate)Predicates.in(subscriptions));
    }

    public void send(Collection<Subscription> subscriptions, Collection<Notification> notifications) {
        if (subscriptions.isEmpty()) {
            return;
        }
        if (notifications.isEmpty() && this.myPendingNotifications.isEmpty()) {
            return;
        }
        RestNotification restNotification = NotificationSender.builder(notifications).build();
        ImmutableMap.Builder newPendingNotifications = ImmutableMap.builder();
        for (Subscription subscription : subscriptions) {
            if (Thread.currentThread().isInterrupted()) break;
            List<Notification> pendingForSubscription = this.myPendingNotifications.get(subscription);
            boolean done = this.send(subscription, restNotification, pendingForSubscription);
            if (done) continue;
            if (pendingForSubscription == null) {
                pendingForSubscription = new ArrayList<Notification>();
            }
            pendingForSubscription.addAll(notifications);
            newPendingNotifications.put((Object)subscription, pendingForSubscription);
        }
        this.myPendingNotifications = newPendingNotifications.build();
    }

    private boolean send(Subscription subscription, RestNotification r, List<Notification> pendingForSubscription) {
        try {
            if (log.isDebugEnabled()) {
                this.logSend(subscription, r, pendingForSubscription);
            }
            return this.send0(subscription, r, pendingForSubscription);
        }
        catch (ResponseException e) {
            log.warn("Cannot send notification to " + subscription, (Throwable)e);
            return false;
        }
        catch (Exception | LinkageError e) {
            log.warn("Cannot send notification to " + subscription, e);
            return true;
        }
    }

    private void logSend(Subscription subscription, RestNotification r, List<Notification> pendingForSubscription) {
        String rString;
        if (this.myObjectMapper == null) {
            this.myObjectMapper = new ObjectMapper();
        }
        try {
            rString = this.myObjectMapper.writeValueAsString((Object)r);
        }
        catch (IOException e) {
            rString = "<cannot stringify>";
        }
        log.debug("sending to " + subscription + ": " + rString + " pending=" + pendingForSubscription);
    }

    private boolean send0(Subscription subscription, RestNotification restNotification, List<Notification> pendingNotifications) throws CredentialsRequiredException, ResponseException {
        if (subscription.isExpired()) {
            return false;
        }
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            restNotification = NotificationSender.builder(pendingNotifications).mergeValues(restNotification).build();
        }
        if (NotificationSender.isEmpty(restNotification)) {
            log.debug("empty notification for {}, not sending", (Object)subscription);
            return true;
        }
        restNotification.senderAppLinkId = subscription.getSenderAppLinkId();
        restNotification.receiverAppLinkId = subscription.getReceiverAppLinkId();
        ReadOnlyApplicationLink link = this.myAppLinkService.getApplicationLink(new ApplicationId(subscription.getSenderAppLinkId()));
        if (link == null) {
            log.warn("cannot send notification to {}: no outgoing app link", (Object)subscription);
            return true;
        }
        return NotificationSender.post(link, subscription.getCallbackUrl(), restNotification);
    }

    private static boolean isEmpty(RestNotification restNotification) {
        return restNotification.pagesChanged == null && restNotification.pagesVisibilityChanged == null && restNotification.spacesChanged == null && restNotification.spacesVisibilityChanged == null && restNotification.usersChanged == null && !restNotification.isAllVisibilitiesChanged && !restNotification.isAllSpacesChanged;
    }

    private static RestNotificationBuilder builder(Collection<Notification> notifications) {
        RestNotificationBuilder builder = new RestNotificationBuilder(notifications.size());
        for (Notification notification : notifications) {
            notification.addTo(builder);
        }
        return builder;
    }

    private static boolean post(ReadOnlyApplicationLink link, String url, Object entity) throws CredentialsRequiredException, ResponseException {
        return Boolean.TRUE.equals(AppLinkClient.post(link, url, entity, SUCCESS_HANDLER, Anonymous.class));
    }

    public static class SuccessHandler
    implements ApplicationLinkResponseHandler<Boolean> {
        public Boolean credentialsRequired(Response response) throws ResponseException {
            log.warn("Credentials required despite Anonymous auth provider requested: {} {}", (Object)response.getStatusCode(), (Object)response.getStatusText());
            return false;
        }

        public Boolean handle(Response response) throws ResponseException {
            log.debug("response {} {}", (Object)response.getStatusCode(), (Object)response.getStatusText());
            return response.isSuccessful();
        }
    }
}

