/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.util.RemoteResponse;
import com.almworks.structure.confluence.helper.util.RemoteResponseAnonymousAppLinkHandler;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLinkClient {
    private static final Logger log = LoggerFactory.getLogger(AppLinkClient.class);
    private static final Function<ReadOnlyApplicationLink, URI> LINK_TO_RPC_URI = new Function<ReadOnlyApplicationLink, URI>(){

        public URI apply(ReadOnlyApplicationLink link) {
            return link.getRpcUrl();
        }
    };
    private static final Function<ReadOnlyApplicationLink, URI> LINK_TO_DISPLAY_URI = new Function<ReadOnlyApplicationLink, URI>(){

        public URI apply(ReadOnlyApplicationLink link) {
            return link.getDisplayUrl();
        }
    };
    private final ReadOnlyApplicationLinkService myLinkService;

    public AppLinkClient(ReadOnlyApplicationLinkService linkService) {
        this.myLinkService = linkService;
    }

    public static <R> RemoteResponse<R> anonymousPost(ReadOnlyApplicationLink link, String url, Object requestEntity, Class<R> responseClass) throws CredentialsRequiredException, ResponseException {
        return (RemoteResponse)AppLinkClient.post(link, url, requestEntity, new RemoteResponseAnonymousAppLinkHandler<R>(responseClass), Anonymous.class);
    }

    public static <T> T post(ReadOnlyApplicationLink link, String url, Object entity, ApplicationLinkResponseHandler<T> handler, Class<? extends AuthenticationProvider> authProvider) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory factory = link.createAuthenticatedRequestFactory(authProvider);
        ApplicationLinkRequest request = factory.createRequest(Request.MethodType.POST, url);
        request.setHeader("Content-Type", "application/json");
        request.setEntity(entity);
        return (T)request.execute(handler);
    }

    public ReadOnlyApplicationLink findLink(URI remoteAppBaseUrl) throws NoAppLinkException {
        try {
            return this.findLinkByLongestPrefixMatch(remoteAppBaseUrl, LINK_TO_RPC_URI);
        }
        catch (NoAppLinkException e) {
            log.warn("Trying application link display URIs");
            return this.findLinkByLongestPrefixMatch(remoteAppBaseUrl, LINK_TO_DISPLAY_URI);
        }
    }

    private ReadOnlyApplicationLink findLinkByLongestPrefixMatch(URI remoteAppBaseUrl, Function<ReadOnlyApplicationLink, URI> linkToUri) throws NoAppLinkException {
        String remoteAppBaseUriNorm = AppLinkClient.normalize(remoteAppBaseUrl);
        for (ReadOnlyApplicationLink candidateLink : this.myLinkService.getApplicationLinks()) {
            String candidateUri = AppLinkClient.normalize((URI)linkToUri.apply((Object)candidateLink));
            if (!remoteAppBaseUriNorm.startsWith(candidateUri)) continue;
            return candidateLink;
        }
        if (log.isWarnEnabled()) {
            String candidateURIs = Joiner.on((String)", ").join(Iterables.transform((Iterable)this.myLinkService.getApplicationLinks(), (Function)Functions.compose((Function)Functions.toStringFunction(), linkToUri)));
            log.warn("Cannot find application link for remote base URL {}. Candidate URIs: {}", (Object)remoteAppBaseUrl, (Object)candidateURIs);
        }
        throw new NoAppLinkException();
    }

    private static String normalize(URI uri) {
        uri = uri.normalize();
        try {
            uri = new URI(null, null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            log.warn("normalize failed for " + uri, (Throwable)e);
        }
        return uri.toASCIIString().toLowerCase(Locale.ROOT);
    }

    public static class NoAppLinkException
    extends Exception {
    }
}

