/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.security;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.event.ApplicationLinkEvent;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SecurityInterceptorEnhancer
implements DisposableBean {
    public static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    private static final Logger logger = LoggerFactory.getLogger(SecurityInterceptorEnhancer.class);
    private static final int DAY_IN_SECONDS = 86400;
    private static final String REFERRER_COOKIE = "structure.pages.referrer";
    private static final String JSESSION_COOKIE_NAME = "JSESSIONID";
    private static final Function<URI, Option<String>> URL_TO_STRING = new Function<URI, Option<String>>(){

        public Option<String> apply(URI uri) {
            return Option.some((Object)uri.toString());
        }
    };
    private static final Function<Cookie, Option<String>> COOKIE_VALUE = new Function<Cookie, Option<String>>(){

        public Option<String> apply(Cookie cookie) {
            return Option.option((Object)cookie.getValue());
        }
    };
    private static final Function<URI, String> URL_ORIGIN = new Function<URI, String>(){

        public String apply(URI uri) {
            return SecurityInterceptorEnhancer.getOrigin(uri.getHost(), uri.getPort());
        }
    };
    private static final Function<URI, String> URL_ORIGIN_WITH_SCHEME = new Function<URI, String>(){

        public String apply(URI uri) {
            return SecurityInterceptorEnhancer.getOriginWithScheme(uri);
        }
    };
    private static final Predicate<Cookie> IS_REFERRER_COOKIE = new Predicate<Cookie>(){

        public boolean apply(Cookie cookie) {
            return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)cookie.getName(), (CharSequence)SecurityInterceptorEnhancer.REFERRER_COOKIE);
        }
    };
    private static final Function<Cookie[], Option<String>> GET_STRUCTURE_REFERRER_COOKIE = new Function<Cookie[], Option<String>>(){

        public Option<String> apply(Cookie[] cookies) {
            return Iterables.findFirst(Arrays.asList(cookies), (Predicate)IS_REFERRER_COOKIE).flatMap(COOKIE_VALUE);
        }
    };
    private final Cache<String, Set<String>> myFrameAncestorsCache;
    private final ReadOnlyApplicationLinkService myLinkService;
    private final EventPublisher myEventPublisher;
    private final Cache<String, Option<String>> myKnownReferrerCache;
    private final Function<String, Option<String>> myKnownReferrerLookup = new Function<String, Option<String>>(){

        public Option<String> apply(String cookieRef) {
            return (Option)SecurityInterceptorEnhancer.this.myKnownReferrerCache.get((Object)cookieRef);
        }
    };

    public SecurityInterceptorEnhancer(ReadOnlyApplicationLinkService linkService, CacheManager cacheManager, EventPublisher eventPublisher) {
        this.myLinkService = linkService;
        this.myEventPublisher = eventPublisher;
        this.myFrameAncestorsCache = cacheManager.getCache("com.almworks.structure.confluence.helper.app-links", (CacheLoader)new FrameAncestorsLoader());
        this.myKnownReferrerCache = cacheManager.getCache("com.almworks.structure.confluence.helper.known-referrer", (CacheLoader)new KnownReferrerLoader());
        eventPublisher.register((Object)this);
    }

    public void setContentSecurityPolicy(HttpServletResponse httpResponse, @Nullable String currentHeader) {
        Set ancestorSources = (Set)this.myFrameAncestorsCache.get((Object)"*");
        String newHeader = this.addAncestorSources(org.apache.commons.lang3.StringUtils.trimToEmpty((String)currentHeader), ancestorSources);
        httpResponse.setHeader(CONTENT_SECURITY_POLICY, newHeader);
    }

    private String addAncestorSources(@NotNull String currentHeader, Set<String> ancestorSources) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)currentHeader)) {
            return this.buildFrameAncestorsOption(ancestorSources);
        }
        Object[] directives = currentHeader.split(";");
        for (int i = 0; i < directives.length; ++i) {
            String directive = directives[i].trim();
            if (!directive.toLowerCase().startsWith("frame-ancestors ")) continue;
            directives[i] = this.extendFrameAncestorsDirective(directive, ancestorSources);
            return org.apache.commons.lang3.StringUtils.join((Object[])directives, (String)";");
        }
        if (!currentHeader.endsWith(";")) {
            currentHeader = currentHeader + ";";
        }
        return currentHeader + this.buildFrameAncestorsOption(ancestorSources);
    }

    private String extendFrameAncestorsDirective(String originalDirective, Set<String> ancestorSources) {
        String[] options = originalDirective.substring("frame-ancestors ".length()).split("\\s+");
        if (options.length == 0 || options.length == 1 && "'none'".equalsIgnoreCase(options[0])) {
            return this.buildFrameAncestorsOption(ancestorSources);
        }
        LinkedHashSet<String> ancestorSet = new LinkedHashSet<String>(Arrays.asList(options));
        ancestorSet.addAll(ancestorSources);
        return this.buildFrameAncestorsOption(ancestorSet);
    }

    private String buildFrameAncestorsOption(Iterable<String> frameAncestors) {
        return "frame-ancestors " + org.apache.commons.lang3.StringUtils.join(frameAncestors, (String)" ");
    }

    public void setXFrameOptions(HttpServletRequest request, HttpServletResponse response, @Nullable String currentHeader) {
        Option cookieReferrer = Option.option((Object)request.getCookies()).flatMap(GET_STRUCTURE_REFERRER_COOKIE).flatMap(this.myKnownReferrerLookup);
        Option referrer = cookieReferrer.orElse(this.headerReferrerSupplier(request));
        if (referrer.isDefined()) {
            String ref = (String)referrer.get();
            logger.debug("Known referrer: " + ref);
            response.setHeader("X-Frame-Options", "Allow-From " + ref);
            if (cookieReferrer.isEmpty()) {
                String cookie = String.format("%s; %s; %s", "structure.pages.referrer=" + ref, "Path=" + StringUtils.defaultIfEmpty((String)StringUtils.removeEnd((String)request.getContextPath(), (String)"/"), (String)"/"), "Max-Age=86400");
                if ("https".equalsIgnoreCase(request.getScheme())) {
                    cookie = cookie + "; SameSite=None; Secure";
                }
                response.addHeader("Set-Cookie", cookie);
            }
        } else {
            logger.debug("Unknown referrer: " + SecurityInterceptorEnhancer.getOrigin(request));
            response.setHeader("X-Frame-Options", currentHeader);
        }
    }

    @NotNull
    private Supplier<Option<String>> headerReferrerSupplier(final HttpServletRequest request) {
        return new Supplier<Option<String>>(){

            public Option<String> get() {
                try {
                    return Option.option((Object)request.getHeader("Referer")).flatMap(SecurityInterceptorEnhancer.this.myKnownReferrerLookup);
                }
                catch (Exception e) {
                    logger.error("Cannot get referrer", (Throwable)e);
                    return Option.none();
                }
            }
        };
    }

    @NotNull
    private Predicate<URI> sameOrigin(final String origin) {
        return new Predicate<URI>(){

            public boolean apply(URI uri) {
                return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)URL_ORIGIN.apply((Object)uri)), (CharSequence)origin);
            }
        };
    }

    @NotNull
    private Set<URI> getKnownReferrers() {
        Iterable links = this.myLinkService.getApplicationLinks();
        LinkedHashSet knownReferrers = Sets.newLinkedHashSet();
        for (ReadOnlyApplicationLink link : links) {
            knownReferrers.add(SecurityInterceptorEnhancer.cutUrl(link.getDisplayUrl()));
            knownReferrers.add(SecurityInterceptorEnhancer.cutUrl(link.getRpcUrl()));
        }
        return knownReferrers;
    }

    public static boolean hasOurCookie(HttpServletRequest request) {
        return com.google.common.collect.Iterables.any(Arrays.asList(request.getCookies()), IS_REFERRER_COOKIE);
    }

    public static void appendSameSite(HttpServletRequest request, HttpServletResponse response) {
        if (!"https".equals(request.getScheme())) {
            return;
        }
        Collection cookieHeaders = response.getHeaders("Set-Cookie");
        boolean firstCookie = true;
        for (String cookieHeader : cookieHeaders) {
            if (cookieHeader == null || cookieHeader.trim().isEmpty()) continue;
            List<HttpCookie> parsedCookies = null;
            try {
                parsedCookies = HttpCookie.parse(cookieHeader);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Cookie header violates the cookie specification and will be ignored.");
            }
            if (parsedCookies == null || parsedCookies.size() != 1) continue;
            String cookieName = parsedCookies.get(0).getName();
            String cookieHeaderToSet = cookieHeader;
            if (cookieName.equals(JSESSION_COOKIE_NAME)) {
                cookieHeaderToSet = SecurityInterceptorEnhancer.appendSameSiteAttribute(cookieHeaderToSet);
            }
            if (firstCookie) {
                response.setHeader("Set-Cookie", cookieHeaderToSet);
                firstCookie = false;
                continue;
            }
            response.addHeader("Set-Cookie", cookieHeaderToSet);
        }
    }

    private static String appendSameSiteAttribute(String cookieHeader) {
        if (!cookieHeader.contains("SameSite")) {
            cookieHeader = cookieHeader + "; SameSite=None";
        } else {
            logger.debug("Not adding SameSite cookie attribute as it already has one!");
        }
        if (!cookieHeader.contains("Secure")) {
            cookieHeader = cookieHeader + "; Secure";
        } else {
            logger.debug("Not adding Secure cookie attribute as it already has one!");
        }
        return cookieHeader;
    }

    @NotNull
    private static URI cutUrl(@NotNull URI url) {
        try {
            return new URI(url.getScheme(), null, url.getHost(), url.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error("Cannot cut the URL " + url, (Throwable)e);
            return url;
        }
    }

    private static String getOrigin(HttpServletRequest request) {
        return SecurityInterceptorEnhancer.getOrigin(request.getServerName(), request.getServerPort());
    }

    private static String getOriginWithScheme(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (scheme == null) {
            return SecurityInterceptorEnhancer.getOrigin(uri.getHost(), port);
        }
        if (scheme.equals("https") && port == 443 || scheme.equals("http") && port == 80) {
            port = -1;
        }
        String withScheme = scheme + "://" + uri.getHost();
        return port > 0 ? withScheme + ":" + port : withScheme;
    }

    private static String getOrigin(@NotNull String host, int port) {
        return port > 0 && port != 80 ? host + ":" + port : host;
    }

    public void destroy() throws Exception {
        logger.warn(this + " stopping");
        this.myEventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onAppLinkEvent(ApplicationLinkEvent event) {
        this.myKnownReferrerCache.removeAll();
        this.myFrameAncestorsCache.removeAll();
    }

    private class KnownReferrerLoader
    implements CacheLoader<String, Option<String>> {
        private KnownReferrerLoader() {
        }

        @Nonnull
        public Option<String> load(@Nonnull String referrer) {
            Set knownReferrers = SecurityInterceptorEnhancer.this.getKnownReferrers();
            if (CollectionUtils.isEmpty((Collection)knownReferrers)) {
                return Option.none();
            }
            try {
                String origin = (String)URL_ORIGIN.apply((Object)new URI(referrer));
                return Iterables.findFirst((Iterable)knownReferrers, (Predicate)SecurityInterceptorEnhancer.this.sameOrigin(origin)).flatMap(URL_TO_STRING);
            }
            catch (URISyntaxException e) {
                logger.error("Cannot load know referrer", (Throwable)e);
                return Option.none();
            }
        }
    }

    private class FrameAncestorsLoader
    implements CacheLoader<String, Set<String>> {
        private FrameAncestorsLoader() {
        }

        @NotNull
        public Set<String> load(@NotNull String referrer) {
            LinkedHashSet<String> ancestorsSet = new LinkedHashSet<String>();
            Iterable knownReferrers = com.google.common.collect.Iterables.transform((Iterable)SecurityInterceptorEnhancer.this.getKnownReferrers(), (Function)URL_ORIGIN_WITH_SCHEME);
            ancestorsSet.add("'self'");
            ancestorsSet.addAll(Sets.newLinkedHashSet((Iterable)knownReferrers));
            return ancestorsSet;
        }
    }
}

