/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.security;

import com.almworks.structure.confluence.helper.security.SecurityInterceptorEnhancer;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecurityFilter.class);
    private final SecurityInterceptorEnhancer myEnhancer;

    public SecurityFilter(SecurityInterceptorEnhancer enhancer) {
        this.myEnhancer = enhancer;
    }

    public void doFilter(final ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                final HttpServletResponse httpResponse = (HttpServletResponse)response;
                chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(httpResponse){

                    public void setHeader(String name, String value) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Security-Policy") || SecurityFilter.this.shouldEnforceCSPHeader((HttpServletRequest)request)) {
                            SecurityFilter.this.myEnhancer.setContentSecurityPolicy(httpResponse, value);
                        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"X-Frame-Options")) {
                            SecurityFilter.this.myEnhancer.setXFrameOptions((HttpServletRequest)request, httpResponse, value);
                        } else {
                            super.setHeader(name, value);
                        }
                    }
                });
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception in servlet filter", (Throwable)e);
        }
    }

    private boolean shouldEnforceCSPHeader(HttpServletRequest request) {
        Optional<String> url = Optional.ofNullable(request.getRequestURL()).map(StringBuffer::toString);
        return url.isPresent() && (this.isMacroBrowserIframe(url.get()) || this.isGadgetPluginRequest(url.get()));
    }

    private boolean isGadgetPluginRequest(String url) {
        return url.contains("/plugins/servlet/gadgets");
    }

    private boolean isMacroBrowserIframe(String url) {
        return url.contains("blank.html");
    }

    public void destroy() {
        logger.warn(this + " stopping");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

