/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper.rest;

import com.almworks.structure.confluence.helper.rest.AbstractResource;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.EnumUtils;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="/space")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class SpaceResource
extends AbstractResource {
    private final SpaceManager mySpaceManager;

    public SpaceResource(SpaceManager spaceManager) {
        this.mySpaceManager = spaceManager;
    }

    @GET
    public Response getAllSpaces(@QueryParam(value="permission") List<String> permissionParams, @QueryParam(value="fields") List<String> fields) {
        ArrayList<RestPermission> permissions = new ArrayList<RestPermission>();
        for (String permission : permissionParams) {
            RestPermission spacePermission = (RestPermission)EnumUtils.getEnum(RestPermission.class, (String)permission.toUpperCase());
            if (spacePermission == null) {
                return SpaceResource.error(Response.Status.BAD_REQUEST, Collections.singletonMap("message", "Invalid permission requested: " + permission));
            }
            permissions.add(spacePermission);
        }
        ArrayList<RestSpace> spaces = new ArrayList<RestSpace>();
        for (Space space : this.fetchSpaces(permissions)) {
            spaces.add(RestSpace.fromSpace(space));
        }
        return SpaceResource.ok(Collections.singletonMap("spaces", this.getSpaceResponseEntities(spaces, new HashSet<String>(fields))));
    }

    @GET
    @Path(value="/{key}")
    public Response getSpace(@PathParam(value="key") String spaceKey) {
        Space space = this.mySpaceManager.getSpace(spaceKey);
        if (space == null) {
            return SpaceResource.error(Response.Status.NOT_FOUND, Collections.singletonMap("message", "Space not found: " + spaceKey));
        }
        return SpaceResource.ok(RestSpace.fromSpace(space));
    }

    private Collection<Space> fetchSpaces(List<RestPermission> permissions) {
        if (permissions.isEmpty()) {
            return this.fetchSpacesByPermission(RestPermission.VIEW);
        }
        LinkedHashSet<Space> spaces = new LinkedHashSet<Space>();
        for (RestPermission rp : permissions) {
            spaces.addAll(this.fetchSpacesByPermission(rp));
        }
        return spaces;
    }

    private List<Space> fetchSpacesByPermission(RestPermission permission) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        SpacesQuery query = SpacesQuery.newQuery().forUser((User)user).withPermission(permission.mySpacePermission).build();
        ListBuilder spaces = this.mySpaceManager.getSpaces(query);
        return spaces.getRange(0, spaces.getAvailableSize());
    }

    private List<?> getSpaceResponseEntities(List<RestSpace> spaces, Set<String> fields) {
        if (fields.isEmpty()) {
            return spaces;
        }
        ArrayList<Map> projections = new ArrayList<Map>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (RestSpace space : spaces) {
            Map projection = (Map)objectMapper.convertValue((Object)space, Map.class);
            projection.keySet().retainAll(fields);
            projections.add(projection);
        }
        return projections;
    }

    @XmlRootElement
    public static class RestSpace {
        @XmlElement
        public long id;
        @XmlElement
        public String key;
        @XmlElement
        public String name;
        @XmlElement
        public Long home;

        static RestSpace fromSpace(Space space) {
            RestSpace restSpace = new RestSpace();
            restSpace.id = space.getId();
            restSpace.key = space.getKey();
            restSpace.name = space.getName();
            restSpace.home = space.getHomePage() != null ? Long.valueOf(space.getHomePage().getId()) : null;
            return restSpace;
        }
    }

    public static enum RestPermission {
        VIEW("VIEWSPACE"),
        MODIFY("EDITSPACE"),
        ADMIN("SETSPACEPERMISSIONS");

        private final String mySpacePermission;

        private RestPermission(String spacePermission) {
            this.mySpacePermission = spacePermission;
        }
    }
}

