/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.google.common.base.Predicate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Subscription {
    public static final Predicate<Subscription> EXPIRED = new Predicate<Subscription>(){

        public boolean apply(Subscription subscription) {
            return subscription.isExpired();
        }
    };
    private final long myDefaultTimeToLiveNs = Long.getLong("structure.subscription.TTL", TimeUnit.MINUTES.toNanos(15L));
    private final long myExpirationNanos;
    private final long myExpirationMillis;
    private final String mySenderAppLinkId;
    private final String mySenderAppLinkRpcUri;
    private final String myCallbackUrl;
    private final String myReceiverAppLinkId;

    public Subscription(@NotNull String senderAppLinkId, @NotNull String senderAppLinkRpcUri, @NotNull String callbackUrl, @NotNull String receiverAppLinkId, @Nullable Long timeToLiveMillis) {
        this.myExpirationNanos = System.nanoTime() + (timeToLiveMillis == null ? this.myDefaultTimeToLiveNs : TimeUnit.MILLISECONDS.toNanos(timeToLiveMillis));
        this.myExpirationMillis = System.currentTimeMillis() + (timeToLiveMillis == null ? TimeUnit.NANOSECONDS.toMillis(this.myDefaultTimeToLiveNs) : timeToLiveMillis.longValue());
        this.mySenderAppLinkId = senderAppLinkId;
        this.mySenderAppLinkRpcUri = senderAppLinkRpcUri;
        this.myCallbackUrl = callbackUrl;
        this.myReceiverAppLinkId = receiverAppLinkId;
    }

    public long getExpirationMillis() {
        return this.myExpirationMillis;
    }

    public boolean isExpired() {
        return System.nanoTime() - this.myExpirationNanos >= 0L;
    }

    @NotNull
    public String getSenderAppLinkId() {
        return this.mySenderAppLinkId;
    }

    public String getSenderAppLinkRpcUri() {
        return this.mySenderAppLinkRpcUri;
    }

    @NotNull
    public String getReceiverAppLinkId() {
        return this.myReceiverAppLinkId;
    }

    @NotNull
    public String getCallbackUrl() {
        return this.myCallbackUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return Objects.equals(this.mySenderAppLinkId, that.mySenderAppLinkId);
    }

    public int hashCode() {
        return Objects.hash(this.mySenderAppLinkId);
    }

    public String toString() {
        return "Subscription@" + Integer.toHexString(System.identityHashCode(this)) + "{myExpirationNanos=" + this.myExpirationNanos + ", myExpirationMillis=" + this.myExpirationMillis + ", mySenderAppLinkId='" + this.mySenderAppLinkId + '\'' + ", mySenderAppLinkRpcUri='" + this.mySenderAppLinkRpcUri + '\'' + ", myCallbackUrl='" + this.myCallbackUrl + '\'' + ", myReceiverAppLinkId='" + this.myReceiverAppLinkId + '\'' + '}';
    }
}

