/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.confluence.helper;

import com.almworks.structure.confluence.helper.AppLinkClient;
import com.almworks.structure.confluence.helper.Subscription;
import com.almworks.structure.confluence.helper.SubscriptionManager;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class AppLinkEventsListeningSubscriptionManager
implements SubscriptionManager,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AppLinkEventsListeningSubscriptionManager.class);
    private static final long MAX_TTL_MILLIS_HARD = TimeUnit.DAYS.toMillis(1L);
    private final CopyOnWriteArrayList<Subscription> mySubscriptions = new CopyOnWriteArrayList();
    private final Object mySubscriptionsLock = new Object();
    private final AppLinkClient myAppLinkClient;
    private final EventPublisher myEventPublisher;

    public AppLinkEventsListeningSubscriptionManager(AppLinkClient appLinkClient, EventPublisher eventPublisher) {
        this.myAppLinkClient = appLinkClient;
        this.myEventPublisher = eventPublisher;
        this.myEventPublisher.register((Object)this);
        log.warn("starting");
    }

    public String toString() {
        return "Structure subscription manager";
    }

    public void destroy() throws Exception {
        log.warn(this + " stopping");
        this.myEventPublisher.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription subscribe(URI remoteAppBaseUrl, String callbackUrl, String remoteAppLinkId, Long timeToLiveMillis) throws AppLinkClient.NoAppLinkException {
        timeToLiveMillis = AppLinkEventsListeningSubscriptionManager.checkTimeToLive(timeToLiveMillis);
        Subscription subscription = this.createSubscription(remoteAppBaseUrl, callbackUrl, remoteAppLinkId, timeToLiveMillis);
        Object object = this.mySubscriptionsLock;
        synchronized (object) {
            String appLinkId = subscription.getSenderAppLinkId();
            List<Subscription> expunged = this.removeSubscriptions(appLinkId);
            if (!expunged.isEmpty()) {
                log.info("Removed duplicate subscriptions: {}", expunged);
            }
            this.mySubscriptions.add(subscription);
            this.mySubscriptionsLock.notify();
            log.info("Added subscription {}", (Object)callbackUrl);
        }
        return subscription;
    }

    private static Long checkTimeToLive(Long timeToLiveMillis) {
        if (timeToLiveMillis != null && timeToLiveMillis > MAX_TTL_MILLIS_HARD) {
            log.warn("capping too large TTL to {}", (Object)MAX_TTL_MILLIS_HARD);
            timeToLiveMillis = MAX_TTL_MILLIS_HARD;
        }
        return timeToLiveMillis;
    }

    private Subscription createSubscription(URI remoteAppBaseUrl, String callbackUrl, String remoteAppLinkId, Long timeToLiveMillis) throws AppLinkClient.NoAppLinkException {
        ReadOnlyApplicationLink link = this.myAppLinkClient.findLink(remoteAppBaseUrl);
        String senderAppLinkId = link.getId().get();
        String senderAppLinkRpcUri = link.getRpcUrl().toString();
        return new Subscription(senderAppLinkId, senderAppLinkRpcUri, callbackUrl, remoteAppLinkId, timeToLiveMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getActiveSubscriptions() throws InterruptedException {
        CopyOnWriteArrayList<Subscription> subscriptions = this.mySubscriptions;
        Collection expiredSubscriptions = Collections2.filter(subscriptions, Subscription.EXPIRED);
        if (!expiredSubscriptions.isEmpty()) {
            ArrayList expiredSubscriptionsList = new ArrayList(expiredSubscriptions);
            subscriptions.removeAll(expiredSubscriptionsList);
            this.mySubscriptions.removeAll(expiredSubscriptionsList);
        }
        if (!subscriptions.isEmpty()) {
            return subscriptions;
        }
        Object object = this.mySubscriptionsLock;
        synchronized (object) {
            while (this.mySubscriptions.isEmpty()) {
                this.mySubscriptionsLock.wait();
            }
            return this.mySubscriptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onApplicationLinkDeleted(ApplicationLinkDeletedEvent event) {
        Object object = this.mySubscriptionsLock;
        synchronized (object) {
            List<Subscription> removed = this.removeSubscriptions(event.getApplicationLink().getId().get());
            if (!removed.isEmpty()) {
                log.info("app link deleted {}: terminated ", (Object)event.getApplicationLink(), removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onApplicationLinkIdChanged(ApplicationLinksIDChangedEvent event) {
        Object object = this.mySubscriptionsLock;
        synchronized (object) {
            List<Subscription> removed = this.removeSubscriptions(event.getOldApplicationId().get());
            if (!removed.isEmpty()) {
                log.warn("app link ID changed to {}: terminated", (Object)event.getOldApplicationId().get(), removed);
            }
        }
    }

    @GuardedBy(value="mySubscriptionsLock")
    @NotNull
    private List<Subscription> removeSubscriptions(String senderAppLinkId) {
        assert (Thread.holdsLock(this.mySubscriptionsLock));
        ArrayList<Subscription> expunged = new ArrayList<Subscription>(Collections2.filter(this.mySubscriptions, AppLinkEventsListeningSubscriptionManager.bySenderAppLinkId(senderAppLinkId)));
        this.mySubscriptions.removeAll(expunged);
        return expunged;
    }

    private static Predicate<Subscription> bySenderAppLinkId(final String appLinkId) {
        return new Predicate<Subscription>(){

            public boolean apply(Subscription subscription) {
                return subscription.getSenderAppLinkId().equals(appLinkId);
            }
        };
    }
}

