/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountdownConfigServlet
extends HttpServlet {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.countdown.CountdownConfigServlet");
    private final LoginUriProvider b;
    private final TemplateRenderer c;
    private final UserManager d;

    public CountdownConfigServlet(@ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport UserManager userManager) {
        this.b = loginUriProvider;
        this.c = templateRenderer;
        this.d = userManager;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug("User [" + String.valueOf(confluenceUser) + "] accessing the Countdown License Configuration page");
        if (confluenceUser == null || !this.d.isSystemAdmin(confluenceUser.getName())) {
            try {
                this.a(httpServletRequest, httpServletResponse);
            }
            catch (IOException iOException) {
                a.error("Error redirecting to login page", (Throwable)iOException);
            }
        }
        httpServletResponse.setContentType("text/html;charset=utf-8");
        try {
            this.c.render("templates/countdown-license-config.vm", (Writer)httpServletResponse.getWriter());
        }
        catch (RenderingException | IOException throwable) {
            a.error("Error rendering template", throwable);
        }
    }

    private void a(HttpServletRequest httpServletRequest, @NotNull HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendRedirect(this.b.getLoginUri(this.a(httpServletRequest)).toString());
    }

    @NotNull
    private URI a(@NotNull HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURL());
        if (httpServletRequest.getQueryString() != null) {
            stringBuilder.append("?");
            stringBuilder.append(httpServletRequest.getQueryString());
        }
        return URI.create(stringBuilder.toString());
    }
}

