/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanDefinitionChecker {
    public static boolean needToRegister(String string, BeanDefinition beanDefinition, BeanDefinitionRegistry beanDefinitionRegistry) throws IllegalStateException {
        if (!beanDefinitionRegistry.containsBeanDefinition(string)) {
            return true;
        }
        BeanDefinition beanDefinition2 = beanDefinitionRegistry.getBeanDefinition(string);
        BeanDefinition beanDefinition3 = beanDefinition2.getOriginatingBeanDefinition();
        if (beanDefinition3 != null) {
            beanDefinition2 = beanDefinition3;
        }
        if (BeanDefinitionChecker.isCompatible(beanDefinition, beanDefinition2)) {
            return false;
        }
        throw new IllegalStateException("Annotation-specified bean name '" + string + "' for bean class [" + beanDefinition.getBeanClassName() + "] conflicts with existing, " + "non-compatible bean definition of same name and class [" + beanDefinition2.getBeanClassName() + "]");
    }

    public static boolean isCompatible(BeanDefinition beanDefinition, BeanDefinition beanDefinition2) {
        return beanDefinition.getBeanClassName().equals(beanDefinition2.getBeanClassName()) || beanDefinition.equals(beanDefinition2);
    }
}

