/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.SpringDMUtil;
import java.net.URL;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class ComponentImportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final BundleContext bundleContext;
    private boolean autoImports;
    private String profileName;
    private final Log log = LogFactory.getLog(this.getClass());

    public ComponentImportBeanFactoryPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.autoImports = false;
        this.profileName = null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)configurableListableBeanFactory;
        Bundle bundle = this.bundleContext.getBundle();
        String[] stringArray = AnnotationIndexReader.splitProfiles(this.profileName);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : AnnotationIndexReader.getIndexFilesForProfiles(stringArray, "imports")) {
            treeSet.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(string, bundle));
        }
        for (String string : treeSet) {
            String[] stringArray2 = StringUtils.split((String)string, (String)"#");
            String string2 = stringArray2[0];
            String string3 = stringArray2.length > 1 ? stringArray2[1] : "";
            try {
                Class<?> clazz = configurableListableBeanFactory.getBeanClassLoader().loadClass(string2);
                this.registerComponentImportBean(beanDefinitionRegistry, clazz, string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error((Object)("Unable to load class '" + string2 + "' for component importation purposes.  Skipping..."));
            }
        }
        this.processMetaData(beanDefinitionRegistry, stringArray);
    }

    private void processMetaData(BeanDefinitionRegistry beanDefinitionRegistry, String[] stringArray) {
        for (String string : AnnotationIndexReader.getIndexFilesForProfiles(stringArray, "metadata.properties")) {
            URL uRL = this.bundleContext.getBundle().getResource(string);
            this.processMetaDataProperties(beanDefinitionRegistry, AnnotationIndexReader.readPropertiesFile(uRL));
        }
    }

    private void processMetaDataProperties(BeanDefinitionRegistry beanDefinitionRegistry, Properties properties) {
    }

    private void registerComponentImportBean(BeanDefinitionRegistry beanDefinitionRegistry, Class clazz, String string) {
        String string2 = string;
        if ("".equals(string2)) {
            string2 = StringUtils.uncapitalize((String)clazz.getSimpleName());
        }
        this.registerBeanDefinition(beanDefinitionRegistry, string2, "(objectClass=" + clazz.getName() + ")", clazz);
    }

    private void registerBeanDefinition(BeanDefinitionRegistry beanDefinitionRegistry, String string, String string2, Class clazz) {
        Class clazz2 = SpringDMUtil.getInstance().getOsgiServiceFactoryBeanFactory().getProxyClass();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz2);
        beanDefinitionBuilder.setAutowireMode(3);
        beanDefinitionBuilder.setRole(2);
        if (StringUtils.isNotBlank((String)string2)) {
            beanDefinitionBuilder.addPropertyValue("filter", (Object)string2);
        }
        beanDefinitionBuilder.addPropertyValue("interfaces", (Object)new Class[]{clazz});
        beanDefinitionBuilder.addPropertyValue("beanClassLoader", (Object)OsgiPlugin.class.getClassLoader());
        AbstractBeanDefinition abstractBeanDefinition = beanDefinitionBuilder.getBeanDefinition();
        beanDefinitionRegistry.registerBeanDefinition(string, (BeanDefinition)abstractBeanDefinition);
    }

    public void setAutoImports(boolean bl) {
        this.autoImports = bl;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }
}

