/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.BeanDefinitionChecker;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class ClassIndexBeanDefinitionScanner {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry registry;
    private final String profileName;
    private final Integer autowireDefault;
    private final BundleContext bundleContext;

    public ClassIndexBeanDefinitionScanner(BeanDefinitionRegistry beanDefinitionRegistry, String string, Integer n, BundleContext bundleContext) {
        this.registry = beanDefinitionRegistry;
        this.profileName = string;
        this.autowireDefault = n;
        this.bundleContext = bundleContext;
    }

    protected Set<BeanDefinitionHolder> doScan() {
        LinkedHashSet<BeanDefinitionHolder> linkedHashSet = new LinkedHashSet<BeanDefinitionHolder>();
        Map<String, BeanDefinition> map = this.findCandidateComponents();
        for (Map.Entry<String, BeanDefinition> entry : map.entrySet()) {
            if (!BeanDefinitionChecker.needToRegister(entry.getKey(), entry.getValue(), this.registry)) continue;
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(entry.getValue(), entry.getKey());
            linkedHashSet.add(beanDefinitionHolder);
            this.registerBeanDefinition(beanDefinitionHolder, this.registry);
        }
        return linkedHashSet;
    }

    public Map<String, BeanDefinition> findCandidateComponents() {
        HashMap<String, BeanDefinition> hashMap = new HashMap<String, BeanDefinition>();
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = AnnotationIndexReader.splitProfiles(this.profileName);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String string : AnnotationIndexReader.getIndexFilesForProfiles(stringArray, "component")) {
            treeSet.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(string, classLoader, this.bundleContext));
        }
        for (String string : treeSet) {
            String[] stringArray2 = StringUtils.split((String)string, (String)"#");
            String string2 = stringArray2[0];
            String string3 = "";
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
            if (StringUtils.isBlank((String)string3)) {
                string3 = Introspector.decapitalize(ClassUtils.getShortName((String)string2));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Found candidate bean '%s' from class '%s'", string3, string2));
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)string2);
            if (null != this.autowireDefault) {
                beanDefinitionBuilder.setAutowireMode(this.autowireDefault.intValue());
            }
            hashMap.put(string3, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return hashMap;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)beanDefinitionRegistry);
    }
}

