/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.extension.OsgiBundleContextAccessor;
import com.atlassian.plugin.spring.scanner.extension.OsgiServiceFactoryBeanFactory;
import com.atlassian.plugin.spring.scanner.extension.gemini.GeminiOsgiBundleContextAccessor;
import com.atlassian.plugin.spring.scanner.extension.gemini.GeminiOsgiServiceFactoryBeanFactory;
import com.atlassian.plugin.spring.scanner.extension.springdm.SpringOsgiBundleContextAccessor;
import com.atlassian.plugin.spring.scanner.extension.springdm.SpringOsgiServiceFactoryBeanFactory;

public class SpringDMUtil {
    private static SpringDMUtil INSTANCE;
    public static final String SPRING_DM_CLASS = "org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean";
    public static final String GEMINI_DM_CLASS = "org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean";
    private OsgiServiceFactoryBeanFactory osgiServiceFactoryBeanFactory;
    private OsgiBundleContextAccessor osgiBundleContextAccessor;

    private SpringDMUtil() {
        try {
            Class.forName(SPRING_DM_CLASS);
            this.osgiServiceFactoryBeanFactory = new SpringOsgiServiceFactoryBeanFactory();
            this.osgiBundleContextAccessor = new SpringOsgiBundleContextAccessor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName(GEMINI_DM_CLASS);
                this.osgiServiceFactoryBeanFactory = new GeminiOsgiServiceFactoryBeanFactory();
                this.osgiBundleContextAccessor = new GeminiOsgiBundleContextAccessor();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new RuntimeException("Couldn't load spring dm nor gemini blueprint osgi service proxy factory bean class! Check you are running on a supported version of atlassian-plugins", classNotFoundException2);
            }
        }
    }

    public static SpringDMUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpringDMUtil();
        }
        return INSTANCE;
    }

    public OsgiServiceFactoryBeanFactory getOsgiServiceFactoryBeanFactory() {
        return this.osgiServiceFactoryBeanFactory;
    }

    public OsgiBundleContextAccessor getOsgiBundleContextAccessor() {
        return this.osgiBundleContextAccessor;
    }
}

